/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.taskview;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.splevo.project.SPLevoProject;
import org.splevo.project.utils.SPLevoProjectUtil;
import org.splevo.ui.commons.project.SPLevoProjectWorkspaceListener;
import org.splevo.ui.commons.project.SPLevoProjectWorkspaceObserver;
import org.splevo.ui.commons.util.ComboBoxSelectionComposite;
import org.splevo.ui.commons.util.CompositeSwitcher;
import org.splevo.ui.commons.util.SingleLevelElementProvider;
import org.splevo.ui.commons.util.WorkspaceUtil;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.listeners.WorkflowListenerUtil;
import org.splevo.ui.views.taskview.Task;
import org.splevo.ui.views.taskview.TaskCreator;
import org.splevo.ui.workflow.BuildSemiAutomatedRefactoringWorkflowDelegate;

public class TaskView
extends ViewPart {
    public static final String ID = "org.splevo.ui.views.taskview.TaskView";
    private static final Logger LOGGER = Logger.getLogger(TaskView.class);
    private Table table = null;
    private TableViewer viewer = null;
    private Action startRefactoringAction = null;
    private CompositeSwitcher compositeSwitcherComposite;
    private Optional<SPLevoProject> selectedSPLevoProject;

    public void createPartControl(Composite parent) {
        this.compositeSwitcherComposite = new CompositeSwitcher(parent);
        new TaskViewComboBoxSelectionComposite((Composite)this.compositeSwitcherComposite);
        this.createViewer((Composite)this.compositeSwitcherComposite);
        this.compositeSwitcherComposite.switchToElement(0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "PrototypeRefactorings.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.startRefactoringAction);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.startRefactoringAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.startRefactoringAction);
    }

    private void makeActions() {
        this.startRefactoringAction = new Action(){

            public void run() {
                String[] splittedByBlank;
                String variationPointID;
                TableItem[] tableItem = TaskView.this.table.getSelection();
                if (tableItem != null && ((variationPointID = (splittedByBlank = tableItem[0].getText(0).split(" "))[0]) != "" || variationPointID != null)) {
                    SPLevoBlackBoard spLevoBlackBoard = new SPLevoBlackBoard();
                    BuildSemiAutomatedRefactoringWorkflowDelegate buildSPLWorkflowConfiguration = new BuildSemiAutomatedRefactoringWorkflowDelegate(spLevoBlackBoard, variationPointID, TaskView.this.getSPLevoProject());
                    WorkflowListenerUtil.runWorkflowAndRunUITask(buildSPLWorkflowConfiguration, "Refactor VP semiautomatically", null, true);
                    TaskView.this.table.remove(TaskView.this.table.getSelectionIndex());
                }
            }
        };
        this.startRefactoringAction.setText("Start Refactoring");
        this.startRefactoringAction.setToolTipText("Start Refactoring");
        this.startRefactoringAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void fillTableWithTasks(boolean forceProjectSelection) {
        if (forceProjectSelection || !this.selectedSPLevoProject.isPresent()) {
            this.compositeSwitcherComposite.switchToElement(0);
            return;
        }
        this.compositeSwitcherComposite.switchToElement(1);
        SPLevoProject project = (SPLevoProject)this.selectedSPLevoProject.get();
        Iterable relevantProjects = Iterables.concat((Iterable)WorkspaceUtil.transformProjectNamesToProjects((Iterable)project.getLeadingProjects()), (Iterable)WorkspaceUtil.transformProjectNamesToProjects((Iterable)project.getIntegrationProjects()));
        try {
            this.viewer.setInput((Object)new TaskCreator().getTasks(relevantProjects));
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.showMessage("Error occured");
        }
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"SPLevoTaskView", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, this.viewer);
        this.table = this.viewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TasksTableLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Description", "Resource", "Path", "Location"};
        int[] bounds = new int[]{300, 100, 50, 200};
        this.createTableViewerColumn(titles[0], bounds[0], 0);
        this.createTableViewerColumn(titles[1], bounds[1], 1);
        this.createTableViewerColumn(titles[2], bounds[2], 2);
        this.createTableViewerColumn(titles[3], bounds[3], 3);
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private SPLevoProject getSPLevoProject() {
        return (SPLevoProject)this.selectedSPLevoProject.orNull();
    }

    public void setSPLevoProject(SPLevoProject splevoProject) {
        this.selectedSPLevoProject = Optional.fromNullable((Object)splevoProject);
        this.fillTableWithTasks(false);
    }

    private class TaskViewComboBoxSelectionComposite
    extends ComboBoxSelectionComposite {
        private final SPLevoProjectWorkspaceObserver projectObserver;
        private final SPLevoProjectWorkspaceListener projectListener;

        public TaskViewComboBoxSelectionComposite(Composite parent) {
            super(parent, "Please select a consolidation project below. Afterwards, this list shows the outstanding refactorings for this project.", "Select");
            this.projectObserver = new SPLevoProjectWorkspaceObserver();
            this.projectListener = new SPLevoProjectWorkspaceListener(){

                public void availableProjectFilesChanged(SPLevoProjectWorkspaceObserver observer) {
                    TaskViewComboBoxSelectionComposite.this.reset();
                }
            };
            this.projectObserver.registerSubscriber(this.projectListener);
            this.projectObserver.startObserver();
            this.reset();
        }

        protected void handleSelectionAfterAccept(IStructuredSelection cvSelection) {
            try {
                if (cvSelection.getFirstElement() instanceof IProject) {
                    SPLevoProject project = SPLevoProjectUtil.loadSPLevoProjectModel((IProject)((IProject)cvSelection.getFirstElement()));
                    TaskView.this.selectedSPLevoProject = Optional.fromNullable((Object)project);
                    if (project != null) {
                        TaskView.this.setSPLevoProject(project);
                        return;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Failure during loading of SPLevoProject.", (Throwable)e);
            }
            TaskView.this.selectedSPLevoProject = Optional.absent();
        }

        protected ILabelProvider getLabelProvider() {
            return new LabelProvider(){

                public String getText(Object element) {
                    if (element != null && element instanceof IProject) {
                        IProject project = (IProject)element;
                        return project.getName();
                    }
                    return "Invalid element";
                }
            };
        }

        protected SingleLevelElementProvider getComboViewerInput() {
            return new SingleLevelElementProvider(){

                public Object[] getElements() {
                    return Iterables.toArray((Iterable)TaskViewComboBoxSelectionComposite.this.projectObserver.getCurrentState(), IProject.class);
                }
            };
        }

        public void dispose() {
            this.projectObserver.stopObserver();
            this.projectObserver.unregisterSubscriber(this.projectListener);
            super.dispose();
        }
    }

    public class TasksTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Task task = (Task)element;
            switch (columnIndex) {
                case 0: {
                    return task.getDescription();
                }
                case 1: {
                    return task.getResource();
                }
                case 2: {
                    return task.getPath();
                }
                case 3: {
                    return new Integer(task.getLocation()).toString();
                }
            }
            return "not specified yet";
        }
    }
}

