/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.vpproperties;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.ui.commons.vpm.VPMAttributeSetter;
import org.splevo.ui.views.vpproperties.VariabilityMechanismPropertyDescriptor;
import org.splevo.vpm.variability.BindingTime;
import org.splevo.vpm.variability.Extensible;
import org.splevo.vpm.variability.VariabilityType;
import org.splevo.vpm.variability.VariationPoint;

public abstract class PropertySource
implements IPropertySource {
    private static final String CATEGORY_REALIZATION = "Variability Realization";
    private static final String CATEGORY_CHARACTERISTICS = "Variability Characteristics";
    private static Logger logger = Logger.getLogger(PropertySource.class);
    protected static final String PROPERTY_ID_EXTENSIBILITY = "extensibile";
    protected static final String PROPERTY_ID_VARIABILITYTYPE = "variabilitytype";
    protected static final String PROPERTY_ID_BINDINGTIME = "bindingtime";
    protected static final String PROPERTY_ID_VARIABILITY_MECHANISM = "variabilitymechanism";
    protected static List<String> variabilityTypes = Lists.newArrayList();
    protected static List<String> bindingTimes = Lists.newArrayList();
    protected static List<String> extensibilities = Lists.newArrayList();

    static {
        for (VariabilityType vt : VariabilityType.VALUES) {
            variabilityTypes.add(vt.getName());
        }
        for (BindingTime bt : BindingTime.VALUES) {
            bindingTimes.add(bt.getName());
        }
        for (Extensible ex : Extensible.VALUES) {
            extensibilities.add(ex.getName());
        }
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ComboBoxPropertyDescriptor variabilityTypeDescriptor = new ComboBoxPropertyDescriptor((Object)PROPERTY_ID_VARIABILITYTYPE, "Variability Type", variabilityTypes.toArray(new String[0]));
        variabilityTypeDescriptor.setCategory(CATEGORY_CHARACTERISTICS);
        ComboBoxPropertyDescriptor bindingTimeDescriptor = new ComboBoxPropertyDescriptor((Object)PROPERTY_ID_BINDINGTIME, "Binding Time", bindingTimes.toArray(new String[0]));
        bindingTimeDescriptor.setCategory(CATEGORY_CHARACTERISTICS);
        ComboBoxPropertyDescriptor extensibilityDescriptor = new ComboBoxPropertyDescriptor((Object)PROPERTY_ID_EXTENSIBILITY, "Extensible", extensibilities.toArray(new String[0]));
        extensibilityDescriptor.setCategory(CATEGORY_CHARACTERISTICS);
        VariabilityMechanismPropertyDescriptor variabilityMechanismDescriptor = new VariabilityMechanismPropertyDescriptor(PROPERTY_ID_VARIABILITY_MECHANISM, "Variability Mechanism");
        variabilityMechanismDescriptor.setCategory(CATEGORY_REALIZATION);
        return new IPropertyDescriptor[]{variabilityTypeDescriptor, bindingTimeDescriptor, extensibilityDescriptor, variabilityMechanismDescriptor};
    }

    public boolean isPropertySet(Object id) {
        return this.getPropertyValue(id) != null;
    }

    public void resetPropertyValue(Object id) {
    }

    protected void setPropertyInternal(VariationPoint variationPoint, Object id, Object value) {
        if (id.equals(PROPERTY_ID_VARIABILITYTYPE) && value instanceof Integer) {
            VariabilityType type = VariabilityType.getByName((String)variabilityTypes.get((Integer)value));
            variationPoint.setVariabilityType(type);
        } else if (id.equals(PROPERTY_ID_EXTENSIBILITY) && value instanceof Integer) {
            Extensible extensibility = Extensible.getByName((String)extensibilities.get((Integer)value));
            variationPoint.setExtensibility(extensibility);
        } else if (id.equals(PROPERTY_ID_BINDINGTIME) && value instanceof Integer) {
            BindingTime bindingTime = BindingTime.getByName((String)bindingTimes.get((Integer)value));
            variationPoint.setBindingTime(bindingTime);
        } else if (id.equals(PROPERTY_ID_VARIABILITY_MECHANISM)) {
            if (value == null) {
                variationPoint.setVariabilityMechanism(null);
            } else if (value instanceof VariabilityRefactoring) {
                VariabilityRefactoring refactoring = (VariabilityRefactoring)value;
                variationPoint.setVariabilityMechanism(refactoring.getVariabilityMechanism());
            }
        } else {
            logger.warn((Object)("Unsupported property value set. Property ID: " + id + " Value: " + value));
        }
    }

    protected boolean setPropertyValue(final Object id, final Object value, final Object oldValue, VariationPoint vp) {
        return this.setPropertyValue(new VPMAttributeSetter.SetAndRevertAction<VariationPoint>(){

            public void set(VariationPoint vp) {
                PropertySource.this.setPropertyInternal(vp, id, value);
            }

            public void revert(VariationPoint vp) {
                PropertySource.this.setPropertyInternal(vp, id, oldValue);
            }
        }, vp);
    }

    protected boolean setPropertyValue(VPMAttributeSetter.SetAndRevertAction<VariationPoint> action, VariationPoint vp) {
        boolean changed = VPMAttributeSetter.applyIfPossible(action, (VariationPoint)vp);
        if (changed) {
            this.saveVariationPoint(vp);
        }
        return changed;
    }

    protected void saveVariationPoint(VariationPoint vp) {
        if (vp.eResource() != null) {
            try {
                vp.eResource().save(null);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to save VariationPoint modifications", (Throwable)e);
            }
        }
    }
}

