/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.vpproperties;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;

public class VariabilityMechanismPropertyDescriptor
extends PropertyDescriptor {
    private static Logger logger = Logger.getLogger(VariabilityMechanismPropertyDescriptor.class);
    private final List<VariabilityRefactoring> refactorings = Lists.newArrayList();

    public VariabilityMechanismPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
        this.refactorings.add(null);
        this.refactorings.addAll(VariabilityRefactoringRegistry.getInstance().getElements());
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ExtendedComboBoxCellEditor editor = new ExtendedComboBoxCellEditor(parent, this.refactorings, this.getLabelProvider(), true);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    public ILabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof VariabilityRefactoring) {
                    VariabilityRefactoring refactoring = (VariabilityRefactoring)element;
                    if (refactoring.getVariabilityMechanism() != null) {
                        return refactoring.getVariabilityMechanism().getName();
                    }
                    logger.warn((Object)String.format("Refactoring without variability mechanism (id=%s, class=%s)", refactoring.getId(), refactoring.getClass().getSimpleName()));
                }
                return super.getText(element);
            }
        };
    }

    protected ICellEditorValidator getValidator() {
        return new ICellEditorValidator(){

            public String isValid(Object value) {
                if (value == null || VariabilityMechanismPropertyDescriptor.this.refactorings.contains(value)) {
                    return null;
                }
                return String.format("%s is no available variability mechanism", value);
            }
        };
    }
}

