/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.workflow;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import de.uka.ipd.sdq.workflow.workbench.AbstractWorkbenchDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.jobs.LoadVPMJob;
import org.splevo.ui.jobs.OpenTaskViewJob;
import org.splevo.ui.jobs.OpenVPMJob;
import org.splevo.ui.jobs.RefreshLeadingCopyProjects;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.jobs.SemiAutomatedRefactorVPMJob;
import org.splevo.ui.workflow.BasicSPLevoProjectWorkflowConfiguration;

public class BuildSemiAutomatedRefactoringWorkflowDelegate
extends AbstractWorkbenchDelegate<BasicSPLevoProjectWorkflowConfiguration, UIBasedWorkflow<Blackboard<?>>> {
    private BasicSPLevoProjectWorkflowConfiguration config = new BasicSPLevoProjectWorkflowConfiguration();
    private final SPLevoBlackBoard blackboard;
    private final String variationPointId;

    public BuildSemiAutomatedRefactoringWorkflowDelegate(SPLevoBlackBoard blackboard, String variationPointId, SPLevoProject project) {
        this.config.setSplevoProject(project);
        this.blackboard = blackboard;
        this.variationPointId = variationPointId;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IJob createWorkflowJob(BasicSPLevoProjectWorkflowConfiguration config) {
        SPLevoProject splevoProject = config.getSplevoProject();
        SequentialBlackboardInteractingJob jobSequence = new SequentialBlackboardInteractingJob();
        jobSequence.setBlackboard((Blackboard)this.blackboard);
        LoadVPMJob loadVPMJob = new LoadVPMJob(splevoProject);
        jobSequence.add((IJob)loadVPMJob);
        SemiAutomatedRefactorVPMJob refactorVPMJob = new SemiAutomatedRefactorVPMJob(splevoProject, this.variationPointId);
        jobSequence.add((IJob)refactorVPMJob);
        jobSequence.add((IJob)new RefreshLeadingCopyProjects(splevoProject));
        LoadVPMJob loadVPMJobAfterRefactoring = new LoadVPMJob(splevoProject);
        jobSequence.add((IJob)loadVPMJobAfterRefactoring);
        jobSequence.add((IJob)new OpenVPMJob(splevoProject, null));
        jobSequence.add((IJob)new OpenTaskViewJob(splevoProject));
        return jobSequence;
    }

    protected boolean useSeparateConsoleForEachJobRun() {
        return false;
    }

    protected BasicSPLevoProjectWorkflowConfiguration getConfiguration() {
        return this.config;
    }
}

