/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.dashboard;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.mihalis.opal.header.Header;
import org.splevo.diffing.Differ;
import org.splevo.diffing.DifferRegistry;
import org.splevo.fm.builder.FeatureModelBuilder;
import org.splevo.fm.builder.FeatureModelBuilderRegistry;
import org.splevo.ui.dashboard.AbstractDashboardTab;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.editors.listener.DifferCheckBoxListener;

public class ConfigurationTab
extends AbstractDashboardTab {
    private final int columnNum = 4;

    public ConfigurationTab(SPLevoProjectEditor splevoProjectEditor, TabFolder tabFolder, int tabIndex) {
        super(splevoProjectEditor);
        this.createTab(tabFolder, tabIndex);
    }

    private void createTab(TabFolder tabFolder, int tabIndex) {
        TabItem configurationTab = new TabItem(tabFolder, 0, tabIndex);
        configurationTab.setText("Configuration");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tabFolder, 512);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite composite = new Composite((Composite)scrolledComposite, 4);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(768));
        this.createHeader(composite);
        this.buildFeatureModelBuilderGroup(composite);
        this.buildDifferConfigurationGroup(composite);
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        configurationTab.setControl((Control)scrolledComposite);
    }

    private Group buildFeatureModelBuilderGroup(Composite composite) {
        FeatureModelBuilder activeFmBuilder;
        Group group = new Group(composite, 4);
        group.setText("FeatureModel Builders");
        group.setLayout((Layout)new GridLayout(4, true));
        group.setLayoutData((Object)new GridData(768));
        Label configLabel = new Label((Composite)group, 0);
        configLabel.setText("Feature Model Builder:");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        final Combo fmBuilderCombo = new Combo((Composite)group, 12);
        fmBuilderCombo.setLayoutData((Object)gridData);
        for (FeatureModelBuilder fmBuilder : FeatureModelBuilderRegistry.getInstance().getElements()) {
            fmBuilderCombo.add(fmBuilder.getLabel());
        }
        FeatureModelBuilder firstFmBuilderInRegistry = (FeatureModelBuilder)Iterables.getFirst((Iterable)FeatureModelBuilderRegistry.getInstance().getElements(), null);
        FeatureModelBuilder defaultFMBuilderInProject = (FeatureModelBuilder)FeatureModelBuilderRegistry.getInstance().getElementById((Object)this.getSPLevoProject().getFmBuilderId());
        FeatureModelBuilder featureModelBuilder = activeFmBuilder = defaultFMBuilderInProject == null ? firstFmBuilderInRegistry : defaultFMBuilderInProject;
        if (activeFmBuilder != null) {
            int index = Iterables.indexOf((Iterable)Lists.newArrayList((Object[])fmBuilderCombo.getItems()), (Predicate)new Predicate<String>(){

                public boolean apply(String itemLabel) {
                    return itemLabel.equals(activeFmBuilder.getLabel());
                }
            });
            fmBuilderCombo.select(index);
            this.getSPLevoProject().setFmBuilderId(activeFmBuilder.getId());
        }
        fmBuilderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String fmBuilderId = FeatureModelBuilderRegistry.getInstance().getIdByLabel(fmBuilderCombo.getText());
                if (fmBuilderId != null && !ConfigurationTab.this.getSPLevoProject().getFmBuilderId().equals(fmBuilderId)) {
                    ConfigurationTab.this.getSPLevoProject().setFmBuilderId(fmBuilderId);
                    ConfigurationTab.this.getSplevoProjectEditor().markAsDirty();
                }
            }
        });
        return group;
    }

    private Group buildDifferConfigurationGroup(Composite composite) {
        Group groupDiffers = new Group(composite, 4);
        groupDiffers.setText("Difference Analysis");
        groupDiffers.setLayout((Layout)new GridLayout(4, true));
        groupDiffers.setLayoutData((Object)new GridData(768));
        LinkedList<Button> differCheckBoxes = new LinkedList<Button>();
        List availableDiffers = DifferRegistry.getInstance().getElements();
        int singleHeight = 20;
        int multipleHeight = 100;
        int yPositionCurrent = 5;
        if (availableDiffers.size() == 1) {
            this.getSPLevoProject().getDifferIds().add((Object)((Differ)availableDiffers.get(0)).getId());
        }
        for (Differ differ : availableDiffers) {
            Button checkBox = new Button((Composite)groupDiffers, 32);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.horizontalSpan = 4;
            checkBox.setLayoutData((Object)gridData);
            checkBox.addSelectionListener((SelectionListener)new DifferCheckBoxListener(checkBox, differ.getId(), this.getSplevoProjectEditor()));
            checkBox.setBounds(10, yPositionCurrent, 450, singleHeight);
            checkBox.setText(differ.getLabel());
            differCheckBoxes.add(checkBox);
            boolean selected = this.getSPLevoProject().getDifferIds().contains((Object)differ.getId());
            checkBox.setSelection(selected);
            yPositionCurrent += singleHeight + 5;
            for (final String configKey : differ.getAvailableConfigurations().keySet()) {
                String defaultValue = (String)differ.getAvailableConfigurations().get(configKey);
                String currentValue = (String)this.getSPLevoProject().getDifferOptions().get((Object)configKey);
                String label = this.getLabelFromKey(configKey);
                Label configLabel = new Label((Composite)groupDiffers, 0);
                configLabel.setBounds(10, yPositionCurrent, 450, singleHeight);
                configLabel.setText(String.valueOf(label) + ":");
                configLabel.setLayoutData((Object)new GridData(2));
                GridData grid = new GridData(768);
                grid.horizontalSpan = 3;
                Text configInput = new Text((Composite)groupDiffers, 2560);
                configInput.setBounds(10, yPositionCurrent += singleHeight + 3, 450, multipleHeight);
                configInput.setLayoutData((Object)grid);
                if (currentValue != null) {
                    configInput.setText(currentValue);
                } else {
                    configInput.setText(defaultValue);
                }
                configInput.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        Text text = (Text)event.widget;
                        ConfigurationTab.this.getSPLevoProject().getDifferOptions().put((Object)configKey, (Object)text.getText());
                        ConfigurationTab.this.getSplevoProjectEditor().markAsDirty();
                    }
                });
                yPositionCurrent += multipleHeight + 5;
            }
        }
        groupDiffers.setBounds(10, 100, 490, yPositionCurrent + 5);
        return groupDiffers;
    }

    private String getLabelFromKey(String configKey) {
        Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)".")).omitEmptyStrings().trimResults();
        Joiner joiner = Joiner.on((String)" ").skipNulls();
        return joiner.join(splitter.split((CharSequence)configKey));
    }

    private void createHeader(Composite composite) {
        Header header = new Header(composite, 0);
        header.setTitle("Configuration");
        header.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/configure.png"));
        header.setDescription("Configuration of the consolidation process.");
        header.setLayoutData((Object)new GridData(4, 2, true, false));
    }
}

