/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.VPMRefinementService;
import org.splevo.vpm.variability.VariationPointModel;

public class VPMApplyRefinementsJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    public void execute(IProgressMonitor monitor) {
        this.logger.info((Object)"Load VPM Model");
        VariationPointModel vpm = ((SPLevoBlackBoard)this.getBlackboard()).getVariationPointModel();
        if (monitor.isCanceled()) {
            monitor.done();
            this.logger.info((Object)"Workflow cancled.");
            return;
        }
        List<Refinement> refinementsToPerform = ((SPLevoBlackBoard)this.getBlackboard()).getRefinementsToApply();
        this.logger.info((Object)("#Refinements to be performed: " + refinementsToPerform.size()));
        VPMRefinementService service = new VPMRefinementService();
        VariationPointModel newVPM = service.applyRefinements(refinementsToPerform, vpm);
        this.logger.info((Object)"Store VPM model in blackboard");
        ((SPLevoBlackBoard)this.getBlackboard()).setVariationPointModel(newVPM);
        monitor.done();
    }

    public String getName() {
        return "Save feature model Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

