/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.listeners;

import de.uka.ipd.sdq.workflow.workbench.AbstractWorkbenchDelegate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.splevo.ui.editors.SPLevoProjectEditor;

public final class WorkflowListenerUtil {
    private WorkflowListenerUtil() {
    }

    public static void runWorkflowAndUpdateUI(AbstractWorkbenchDelegate<?, ?> workflowDelegate, final String workflowTitle, final SPLevoProjectEditor splevoProjectEditor) {
        Runnable uiProcess = new Runnable(){

            @Override
            public void run() {
                splevoProjectEditor.updateUI(String.valueOf(workflowTitle) + " completed");
            }
        };
        WorkflowListenerUtil.runWorkflowAndRunUITask(workflowDelegate, workflowTitle, uiProcess);
    }

    public static void runWorkflowAndRunUITask(AbstractWorkbenchDelegate<?, ?> workflowDelegate, String workflowTitle, Runnable uiRunnable) {
        WorkflowListenerUtil.runWorkflowAndRunUITask(workflowDelegate, workflowTitle, uiRunnable, false);
    }

    public static void runWorkflowAndRunUITask(final AbstractWorkbenchDelegate<?, ?> workflowDelegate, final String workflowTitle, final Runnable uiRunnable, boolean runHidden) {
        Job job = new Job(workflowTitle){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(workflowTitle, -1);
                Action action = new Action(workflowTitle){};
                workflowDelegate.setProgressMonitor(monitor);
                workflowDelegate.run((IAction)action);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                if (uiRunnable != null) {
                    Display.getDefault().asyncExec(uiRunnable);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        if (runHidden) {
            job.setUser(false);
            job.setSystem(false);
        } else {
            job.setUser(true);
        }
        job.schedule();
    }
}

