/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser;

import org.apache.log4j.Logger;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.refinementbrowser.RefinementModelProvider;
import org.splevo.ui.refinementbrowser.VPMRefinementBrowserInput;
import org.splevo.vpm.refinement.RefinementModel;

public class OpenRefinementBrowserRunnable
implements Runnable {
    private static Logger logger = Logger.getLogger(OpenRefinementBrowserRunnable.class);
    private SPLevoProjectEditor splevoProjectEditor;
    private RefinementModelProvider refinementModelProvider;

    public OpenRefinementBrowserRunnable(SPLevoProjectEditor splevoProjectEditor, RefinementModelProvider refinementModelProvider) {
        this.refinementModelProvider = refinementModelProvider;
        this.splevoProjectEditor = splevoProjectEditor;
    }

    @Override
    public void run() {
        try {
            RefinementModel refinementModel = this.refinementModelProvider.getRefinementModel();
            VPMRefinementBrowserInput input = new VPMRefinementBrowserInput(refinementModel, this.splevoProjectEditor);
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            activePage.openEditor((IEditorInput)input, "org.splevo.ui.editor.VPMRefinementEditor");
        }
        catch (PartInitException e) {
            logger.error((Object)"Editor could not be opened", (Throwable)e);
        }
    }
}

