/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.splevo.ui.listeners.EObjectChangedListener;
import org.splevo.vpm.refinement.Refinement;

public abstract class RefinementTreeContentProviderBase<T extends EObject>
implements ITreeContentProvider {
    protected T topLevelElement;

    public void dispose() {
        if (this.topLevelElement != null) {
            this.removeChangeListeningAdapterFromEObject((EObject)this.topLevelElement);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != null) {
            this.removeChangeListeningAdapterFromEObject((EObject)oldInput);
        }
        if (newInput != null) {
            this.topLevelElement = (EObject)newInput;
            this.topLevelElement.eAdapters().add((Object)new EObjectChangedAdapter(viewer, this.hashCode()));
        }
    }

    private void removeChangeListeningAdapterFromEObject(EObject obj) {
        Iterables.removeIf((Iterable)obj.eAdapters(), (Predicate)new Predicate<Adapter>(){

            public boolean apply(Adapter arg0) {
                if (!(arg0 instanceof EObjectChangedAdapter)) {
                    return false;
                }
                return ((EObjectChangedAdapter)arg0).getOwnerId() == this.hashCode();
            }
        });
    }

    public Object[] getElements(Object inputElement) {
        if (this.topLevelElement == null) {
            return ObjectArrays.newArray(Object.class, (int)0);
        }
        return this.getElements();
    }

    protected abstract Object[] getElements();

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    private static class EObjectChangedAdapter
    extends EObjectChangedListener {
        private final Viewer viewer;
        private final int ownerId;

        public EObjectChangedAdapter(Viewer viewer, int ownerId) {
            super(new Predicate<Notification>(){

                public boolean apply(Notification arg0) {
                    return arg0.getNotifier() instanceof Refinement;
                }
            });
            this.viewer = viewer;
            this.ownerId = ownerId;
        }

        @Override
        protected void reactOnChange(Notification notification) {
            Display viewerDisplay;
            try {
                viewerDisplay = this.viewer.getControl().getDisplay();
            }
            catch (SWTException e) {
                return;
            }
            viewerDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!EObjectChangedAdapter.this.viewer.getControl().isDisposed()) {
                        EObjectChangedAdapter.this.viewer.refresh();
                    }
                }
            });
        }

        public int getOwnerId() {
            return this.ownerId;
        }
    }
}

