/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.splevo.ui.sourceconnection.helper.FileWithID;
import org.splevo.ui.sourceconnection.helper.IndexedLineNumber;
import org.splevo.ui.sourceconnection.helper.NumbersTextPair;

public final class UnifiedDiffFileHandler {
    private static final Logger LOGGER = Logger.getLogger(UnifiedDiffFileHandler.class);
    private static UnifiedDiffFileHandler instance = null;

    private UnifiedDiffFileHandler() {
    }

    public List<NumbersTextPair> readLeadingFileToData(FileWithID leadingFile) {
        ArrayList<NumbersTextPair> leadingData = new ArrayList<NumbersTextPair>();
        try {
            String[] leadingContent = this.readFileToLines(leadingFile.getFile());
            int i = 0;
            while (i < leadingContent.length) {
                ArrayList<IndexedLineNumber> lineNumbers = new ArrayList<IndexedLineNumber>();
                lineNumbers.add(new IndexedLineNumber(0, i + 1));
                leadingData.add(new NumbersTextPair(lineNumbers, leadingContent[i]));
                ++i;
            }
        }
        catch (IOException exception) {
            LOGGER.error((Object)("An error occured while reading leading file \"" + leadingFile.getFile().getAbsolutePath() + "\""), (Throwable)exception);
        }
        return leadingData;
    }

    public List<String[]> readIntegrationCopies(List<FileWithID> integrationFiles) {
        ArrayList<String[]> integrationCopiesAsArray = new ArrayList<String[]>();
        for (FileWithID integrationCopy : integrationFiles) {
            String[] integrationCopyTextAsArray = null;
            try {
                integrationCopyTextAsArray = this.readFileToLines(integrationCopy.getFile());
            }
            catch (IOException e) {
                LOGGER.error((Object)("An error occured while reading integration copy \"" + integrationCopy.getFile().getAbsolutePath() + "\""), (Throwable)e);
            }
            integrationCopiesAsArray.add(integrationCopyTextAsArray);
        }
        return integrationCopiesAsArray;
    }

    private String[] readFileToLines(File file) throws IOException {
        String fileContent = FileUtils.readFileToString((File)file, (String)Charsets.UTF_8.name());
        return fileContent.split("\\r?\\n");
    }

    public void writeUnifiedLines(List<String> unifiedTextLines, File toFile) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (String string : unifiedTextLines) {
            builder.append(String.valueOf(string) + "\n");
        }
        FileUtils.write((File)toFile, (CharSequence)builder.toString(), (String)Charsets.UTF_8.name());
    }

    public static synchronized UnifiedDiffFileHandler getInstance() {
        if (instance == null) {
            instance = new UnifiedDiffFileHandler();
        }
        return instance;
    }
}

