/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection.handler;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public class CopyContainingFilenameHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection curSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (curSelection == null || !(curSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)curSelection;
        LinkedHashMultiset<String> filePaths = this.collectFilePaths(selection);
        String clipboardContent = this.buildClipboardContent(filePaths);
        this.copyToClipboard(clipboardContent);
        return null;
    }

    private void copyToClipboard(String clipboardContent) {
        Display display = Display.getCurrent();
        Clipboard clipboard = new Clipboard(display);
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] transfers = new Transfer[]{textTransfer};
        Object[] data = new Object[]{clipboardContent};
        clipboard.setContents(data, transfers);
        clipboard.dispose();
    }

    private String buildClipboardContent(LinkedHashMultiset<String> filePaths) {
        StringBuilder copyContent = new StringBuilder();
        for (String file : filePaths.elementSet()) {
            copyContent.append(FilenameUtils.getName((String)file));
            copyContent.append(",");
            copyContent.append(filePaths.count((Object)file));
            copyContent.append("\r\n");
        }
        return copyContent.toString();
    }

    private LinkedHashMultiset<String> collectFilePaths(IStructuredSelection selection) {
        LinkedHashMultiset filePaths = LinkedHashMultiset.create();
        LinkedHashSet vps = Sets.newLinkedHashSet();
        for (Object selectedItem : selection.toList()) {
            if (selectedItem instanceof Variant) {
                vps.add(((Variant)selectedItem).getVariationPoint());
                continue;
            }
            if (!(selectedItem instanceof VariationPoint)) continue;
            vps.add((VariationPoint)selectedItem);
        }
        for (VariationPoint vp : vps) {
            if (vp == null) continue;
            filePaths.add((Object)this.getFile(vp));
        }
        return filePaths;
    }

    private String getFile(VariationPoint vp) {
        return vp.getLocation().getSourceLocation().getFilePath();
    }
}

