/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.taskview;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.splevo.refactoring.TodoTagCustomizer;
import org.splevo.refactoring.TodoTagCustomizerRegistry;
import org.splevo.ui.views.taskview.Task;

public class TaskCreator {
    public Task[] getTasks(Iterable<IProject> relevantProjects) throws CoreException {
        ArrayList tasks = Lists.newArrayList();
        Iterable todoTags = Iterables.concat((Iterable)Iterables.transform((Iterable)TodoTagCustomizerRegistry.getInstance().getElements(), (Function)new Function<TodoTagCustomizer, Iterable<String>>(){

            public Iterable<String> apply(TodoTagCustomizer input) {
                return input.getTodoTags();
            }
        }));
        for (IProject relevantProject : relevantProjects) {
            ArrayList toDoTasks = Lists.newArrayList((Object[])relevantProject.findMarkers("org.eclipse.core.resources.taskmarker", true, 2));
            for (IMarker toDoTask : toDoTasks) {
                final String toDoTaskDescritpion = (String)toDoTask.getAttribute("message");
                Optional todoTag = Iterables.tryFind((Iterable)todoTags, (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        return toDoTaskDescritpion.contains(input);
                    }
                });
                if (!todoTag.isPresent()) continue;
                String variationPointID = toDoTaskDescritpion.replace(String.valueOf((String)todoTag.get()) + " ", "");
                tasks.add(new Task(variationPointID, toDoTask.getResource().getName(), toDoTask.getResource().getFullPath().toString(), (Integer)toDoTask.getAttribute("lineNumber")));
            }
        }
        return tasks.toArray(new Task[tasks.size()]);
    }
}

