/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.vpproperties;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;
import org.splevo.ui.commons.vpm.VPMAttributeSetter;
import org.splevo.ui.views.vpproperties.PropertySource;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;

public class VariationPointGroupPropertySource
extends PropertySource {
    private final List<VariationPoint> vps;

    public VariationPointGroupPropertySource(VariationPointGroup vpg) {
        this.vps = vpg.getVariationPoints();
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("variabilitytype")) {
            return variabilityTypes.indexOf(this.getVariabilityType());
        }
        if (id.equals("extensibile")) {
            return extensibilities.indexOf(this.getExtensibility());
        }
        if (id.equals("bindingtime")) {
            return bindingTimes.indexOf(this.getBindingTime());
        }
        if (id.equals("variabilitymechanism")) {
            return this.getVariabilityMechanism();
        }
        return null;
    }

    private String getVariabilityType() {
        int i = 0;
        while (i < this.vps.size()) {
            if (!this.vps.get(0).getVariabilityType().equals((Object)this.vps.get(i).getVariabilityType())) {
                return null;
            }
            ++i;
        }
        return this.vps.get(0).getVariabilityType().getName();
    }

    private String getExtensibility() {
        int i = 0;
        while (i < this.vps.size()) {
            if (!this.vps.get(0).getExtensibility().equals((Object)this.vps.get(i).getExtensibility())) {
                return null;
            }
            ++i;
        }
        return this.vps.get(0).getExtensibility().getName();
    }

    private String getBindingTime() {
        int i = 0;
        while (i < this.vps.size()) {
            if (!this.vps.get(0).getBindingTime().equals((Object)this.vps.get(i).getBindingTime())) {
                return null;
            }
            ++i;
        }
        return this.vps.get(0).getBindingTime().getName();
    }

    private VariabilityRefactoring getVariabilityMechanism() {
        int i = 0;
        while (i < this.vps.size()) {
            if (this.vps.get(i).getVariabilityMechanism() == null || !this.vps.get(0).getVariabilityMechanism().getRefactoringID().equals(this.vps.get(i).getVariabilityMechanism().getRefactoringID())) {
                return null;
            }
            ++i;
        }
        String refactoringId = this.vps.get(0).getVariabilityMechanism().getRefactoringID();
        VariabilityRefactoring refactoring = (VariabilityRefactoring)VariabilityRefactoringRegistry.getInstance().getElementById((Object)refactoringId);
        return refactoring;
    }

    public void setPropertyValue(final Object id, final Object value) {
        final Object oldValue = this.getPropertyValue(id);
        if (Objects.equal((Object)oldValue, (Object)value)) {
            return;
        }
        ArrayList<VPMAttributeSetter.SetAndRevertAction<VariationPoint>> transaction = new ArrayList<VPMAttributeSetter.SetAndRevertAction<VariationPoint>>();
        for (VariationPoint vp : this.vps) {
            VPMAttributeSetter.SetAndRevertAction<VariationPoint> action = new VPMAttributeSetter.SetAndRevertAction<VariationPoint>(){

                public void set(VariationPoint vp) {
                    VariationPointGroupPropertySource.this.setPropertyInternal(vp, id, value);
                }

                public void revert(VariationPoint vp) {
                    VariationPointGroupPropertySource.this.setPropertyInternal(vp, id, oldValue);
                }
            };
            transaction.add(action);
            if (this.setPropertyValue(action, vp)) continue;
            this.characteristicRollback(transaction);
            break;
        }
    }

    private void characteristicRollback(List<VPMAttributeSetter.SetAndRevertAction<VariationPoint>> transaction) {
        int i = 0;
        while (i < transaction.size()) {
            VariationPoint vp = this.vps.get(i);
            transaction.get(i).revert((EObject)vp);
            this.saveVariationPoint(vp);
            ++i;
        }
    }
}

