/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizards.vpmanalysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.splevo.ui.util.UIUtil;
import org.splevo.ui.wizards.vpmanalysis.RefinementTypeLabelProvider;
import org.splevo.ui.workflow.VPMAnalysisWorkflowConfiguration;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.refinement.BasicDetectionRule;
import org.splevo.vpm.analyzer.refinement.DetectionRule;
import org.splevo.vpm.refinement.RefinementType;

public class ResultHandlingConfigurationPage
extends WizardPage {
    private VPMAnalysisWorkflowConfiguration.ResultPresentation resultPresentation;
    private boolean useMergeDetection = true;
    private boolean fullRefinementReasons = false;
    private Map<Integer, Set<String>> labelsToGroupID;
    private Map<Integer, RefinementType> refinementTypeToGroupID;
    private Group ruleConfigurationGroup;
    private ListViewer listViewerAnalysis;
    private Button removeRuleButton;
    private Composite detailComp;
    private List<VPMAnalyzer> analyzers;
    private List<DetectionRule> detectionRules;

    public ResultHandlingConfigurationPage(VPMAnalysisWorkflowConfiguration defaultConfiguration) {
        super("ResultHandlingConfiguration");
        this.setTitle("Analysis Result Handling");
        this.setDescription("Configure how you would like to handle the analysis result.");
        this.analyzers = new LinkedList<VPMAnalyzer>();
        this.labelsToGroupID = new HashMap<Integer, Set<String>>();
        this.refinementTypeToGroupID = new HashMap<Integer, RefinementType>();
        this.resultPresentation = defaultConfiguration.getPresentation();
        this.detectionRules = defaultConfiguration.getDetectionRules();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FormLayout());
        this.setControl((Control)container);
        Group resultPresentationGrp = this.createResultPresentationGroup(container);
        this.ruleConfigurationGroup = new Group(container, 0);
        this.ruleConfigurationGroup.setText("Refinement Detection");
        this.ruleConfigurationGroup.setLayout((Layout)new FormLayout());
        FormData ruleConfigGroupFD = this.createFormDataMargin((Control)resultPresentationGrp);
        this.ruleConfigurationGroup.setLayoutData((Object)ruleConfigGroupFD);
        this.generateRuleComponents((Composite)this.ruleConfigurationGroup);
        ruleConfigGroupFD.height = this.ruleConfigurationGroup.computeSize((int)-1, (int)-1).y;
        boolean isRefinementBrowser = this.resultPresentation == VPMAnalysisWorkflowConfiguration.ResultPresentation.REFINEMENT_BROWSER;
        this.enableRulesDetection(isRefinementBrowser);
    }

    private void fillInitialRuleMaps() {
        if (this.detectionRules.size() > 0) {
            return;
        }
        ArrayList<String> edgeLabels = new ArrayList<String>();
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        for (VPMAnalyzer analyzer : service.getAvailableAnalyzers()) {
            edgeLabels.add(analyzer.getRelationshipLabel());
        }
        this.detectionRules.clear();
        this.detectionRules.add((DetectionRule)new BasicDetectionRule(edgeLabels, RefinementType.GROUPING));
        this.labelsToGroupID.clear();
        this.refinementTypeToGroupID.clear();
        for (DetectionRule rule : this.detectionRules) {
            int id = this.findNextFreeID();
            this.labelsToGroupID.put(id, new HashSet());
            for (VPMAnalyzer analyzer : this.analyzers) {
                if (!rule.getEdgeLabels().contains(analyzer.getRelationshipLabel())) continue;
                this.labelsToGroupID.get(id).add(analyzer.getRelationshipLabel());
            }
            this.refinementTypeToGroupID.put(id, rule.getRefinementType());
        }
        this.listViewerAnalysis.refresh();
    }

    private void removeInvalidEdgeLabelsFromRules() {
        for (Integer id : this.labelsToGroupID.keySet()) {
            Set<String> labels = this.labelsToGroupID.get(id);
            HashSet<String> toBeDeleted = new HashSet<String>();
            for (String label : labels) {
                boolean labelHasAnalyer = false;
                for (VPMAnalyzer analyzer : this.analyzers) {
                    if (!analyzer.getRelationshipLabel().equals(label)) continue;
                    labelHasAnalyer = true;
                    break;
                }
                if (labelHasAnalyer) continue;
                toBeDeleted.add(label);
            }
            labels.removeAll(toBeDeleted);
        }
    }

    private void generateRuleComponents(Composite parent) {
        Group mergeDetectionGroup = this.createMergeDetectionGroup(parent);
        Group fullRefinementReasonsGroup = this.createRefinementReasonsGroup(parent, (Control)mergeDetectionGroup);
        Group ruleListGroup = new Group(parent, 0);
        ruleListGroup.setLayout((Layout)new GridLayout(2, true));
        ruleListGroup.setText("Rules");
        FormData groupFD = new FormData();
        groupFD.top = new FormAttachment((Control)fullRefinementReasonsGroup, 10);
        groupFD.bottom = new FormAttachment(100);
        groupFD.left = new FormAttachment(0);
        groupFD.right = new FormAttachment(30);
        ruleListGroup.setLayoutData((Object)groupFD);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.listViewerAnalysis = new ListViewer((Composite)ruleListGroup, 2816);
        this.listViewerAnalysis.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewerAnalysis.setInput(this.labelsToGroupID.keySet());
        this.listViewerAnalysis.setLabelProvider((IBaseLabelProvider)new RefinementTypeLabelProvider(this.labelsToGroupID, this.refinementTypeToGroupID));
        this.listViewerAnalysis.getList().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.listViewerAnalysis.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResultHandlingConfigurationPage.this.rebuildDetailComp();
            }
        });
        Button addRuleButton = new Button((Composite)ruleListGroup, 8);
        addRuleButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        addRuleButton.setLayoutData((Object)gridData);
        addRuleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LinkedHashSet<String> labels = new LinkedHashSet<String>();
                for (VPMAnalyzer analyzer : ResultHandlingConfigurationPage.this.analyzers) {
                    labels.add(analyzer.getRelationshipLabel());
                }
                int id = ResultHandlingConfigurationPage.this.findNextFreeID();
                ResultHandlingConfigurationPage.this.labelsToGroupID.put(id, labels);
                ResultHandlingConfigurationPage.this.refinementTypeToGroupID.put(id, RefinementType.GROUPING);
                ResultHandlingConfigurationPage.this.listViewerAnalysis.refresh();
                ResultHandlingConfigurationPage.this.update();
            }
        });
        this.removeRuleButton = new Button((Composite)ruleListGroup, 8);
        this.removeRuleButton.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/cross.png"));
        this.removeRuleButton.setEnabled(false);
        this.removeRuleButton.setLayoutData((Object)gridData);
        this.removeRuleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Integer selectedID = ResultHandlingConfigurationPage.this.getSelectedID();
                ResultHandlingConfigurationPage.this.labelsToGroupID.remove(selectedID);
                ResultHandlingConfigurationPage.this.refinementTypeToGroupID.remove(selectedID);
                ResultHandlingConfigurationPage.this.listViewerAnalysis.refresh();
                ResultHandlingConfigurationPage.this.removeRuleDetailComponents();
                ResultHandlingConfigurationPage.this.detailComp.pack();
                ResultHandlingConfigurationPage.this.showHowToConfigureRulesInfo(ResultHandlingConfigurationPage.this.detailComp);
                ResultHandlingConfigurationPage.this.update();
            }
        });
        Group ruleDetailGroup = new Group(parent, 0);
        ruleDetailGroup.setText("Details");
        FormData groupDetailFD = new FormData();
        groupDetailFD.top = new FormAttachment((Control)fullRefinementReasonsGroup, 10);
        groupDetailFD.bottom = new FormAttachment(100);
        groupDetailFD.left = new FormAttachment((Control)ruleListGroup, 5);
        groupDetailFD.right = new FormAttachment(100);
        ruleDetailGroup.setLayoutData((Object)groupDetailFD);
        ruleDetailGroup.setLayout((Layout)new RowLayout());
        this.detailComp = new Composite((Composite)ruleDetailGroup, 0);
        this.detailComp.setLayout((Layout)new GridLayout(3, true));
    }

    private Group createResultPresentationGroup(Composite parent) {
        Group resultPresentationGrp = new Group(parent, 0);
        resultPresentationGrp.setText("Analysis Result Presentation");
        resultPresentationGrp.setLayout((Layout)new RowLayout(256));
        FormData resultPresentationFD = this.createFormDataMargin((Control)parent);
        resultPresentationGrp.setLayoutData((Object)resultPresentationFD);
        Button vpmGraphBtn = new Button((Composite)resultPresentationGrp, 16);
        vpmGraphBtn.setText("VPM Graph");
        vpmGraphBtn.setToolTipText("Show VPM Graph only. Refinement detection will be skipped.");
        boolean isVPMGraphActivated = this.resultPresentation == VPMAnalysisWorkflowConfiguration.ResultPresentation.RELATIONSHIP_GRAPH_ONLY;
        vpmGraphBtn.setSelection(isVPMGraphActivated);
        vpmGraphBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ResultHandlingConfigurationPage.this.resultPresentation = VPMAnalysisWorkflowConfiguration.ResultPresentation.RELATIONSHIP_GRAPH_ONLY;
                ResultHandlingConfigurationPage.this.enableRulesDetection(false);
                ResultHandlingConfigurationPage.this.update();
            }
        });
        Button refBrowserBtn = new Button((Composite)resultPresentationGrp, 16);
        refBrowserBtn.setText("Refinement Browser");
        refBrowserBtn.setToolTipText("Show analysis results in the refinement browser.");
        refBrowserBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ResultHandlingConfigurationPage.this.resultPresentation = VPMAnalysisWorkflowConfiguration.ResultPresentation.REFINEMENT_BROWSER;
                ResultHandlingConfigurationPage.this.enableRulesDetection(true);
                ResultHandlingConfigurationPage.this.update();
            }
        });
        refBrowserBtn.setSelection(!isVPMGraphActivated);
        resultPresentationFD.height = resultPresentationGrp.computeSize((int)-1, (int)-1).y - 15;
        return resultPresentationGrp;
    }

    private FormData createFormDataMargin(Control previousElement) {
        FormData resultPresentationFD = new FormData();
        resultPresentationFD.top = previousElement != null ? new FormAttachment(previousElement, 10) : new FormAttachment(5);
        resultPresentationFD.left = new FormAttachment(0);
        resultPresentationFD.right = new FormAttachment(100);
        return resultPresentationFD;
    }

    private Group createMergeDetectionGroup(Composite parent) {
        Group mergeDetectionGroup = new Group(parent, 0);
        mergeDetectionGroup.setText("Merge Detection");
        mergeDetectionGroup.setLayout((Layout)new FormLayout());
        FormData mergeDectionFD = this.createFormDataMargin(null);
        mergeDetectionGroup.setLayoutData((Object)mergeDectionFD);
        Button yesMergeBtn = new Button((Composite)mergeDetectionGroup, 16);
        yesMergeBtn.setText("yes");
        yesMergeBtn.setToolTipText("Analyse related VPs if they can be merged.");
        yesMergeBtn.setSelection(this.useMergeDetection);
        yesMergeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ResultHandlingConfigurationPage.this.useMergeDetection = true;
                ResultHandlingConfigurationPage.this.update();
            }
        });
        Button noMergeBtn = new Button((Composite)mergeDetectionGroup, 16);
        noMergeBtn.setText("no");
        noMergeBtn.setToolTipText("Detect group refinements only.");
        noMergeBtn.setSelection(!this.useMergeDetection);
        noMergeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ResultHandlingConfigurationPage.this.useMergeDetection = false;
                ResultHandlingConfigurationPage.this.update();
            }
        });
        FormData noBtnFD = this.createFormDataMargin(null);
        noBtnFD.left = new FormAttachment((Control)yesMergeBtn, 10);
        noMergeBtn.setLayoutData((Object)noBtnFD);
        mergeDectionFD.height = mergeDetectionGroup.computeSize((int)-1, (int)-1).y - 15;
        return mergeDetectionGroup;
    }

    private Group createRefinementReasonsGroup(Composite parent, Control previousElement) {
        Group fullRefinementReasonsGroup = new Group(parent, 0);
        fullRefinementReasonsGroup.setText("Full Refinement Reasons");
        fullRefinementReasonsGroup.setLayout((Layout)new FormLayout());
        FormData fullRefinementReasonsFD = this.createFormDataMargin(previousElement);
        fullRefinementReasonsGroup.setLayoutData((Object)fullRefinementReasonsFD);
        Button yesFullRefinementReasonsBtn = new Button((Composite)fullRefinementReasonsGroup, 16);
        yesFullRefinementReasonsBtn.setText("yes");
        yesFullRefinementReasonsBtn.setToolTipText("Collects all possible refinement reasons.");
        yesFullRefinementReasonsBtn.setSelection(this.fullRefinementReasons);
        yesFullRefinementReasonsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ResultHandlingConfigurationPage.this.fullRefinementReasons = true;
                ResultHandlingConfigurationPage.this.update();
            }
        });
        Button noFullRefinementReasonsBtn = new Button((Composite)fullRefinementReasonsGroup, 16);
        noFullRefinementReasonsBtn.setText("no");
        noFullRefinementReasonsBtn.setToolTipText("Collects only the first refinement reason.");
        noFullRefinementReasonsBtn.setSelection(!this.fullRefinementReasons);
        noFullRefinementReasonsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ResultHandlingConfigurationPage.this.fullRefinementReasons = false;
                ResultHandlingConfigurationPage.this.update();
            }
        });
        FormData noBtnFD = this.createFormDataMargin(null);
        noBtnFD.left = new FormAttachment((Control)yesFullRefinementReasonsBtn, 10);
        noFullRefinementReasonsBtn.setLayoutData((Object)noBtnFD);
        fullRefinementReasonsFD.height = fullRefinementReasonsGroup.computeSize((int)-1, (int)-1).y - 15;
        return fullRefinementReasonsGroup;
    }

    protected void removeRuleDetailComponents() {
        Control[] controlArray = this.detailComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private void showHowToConfigureRulesInfo(Composite parent) {
        Label infoLabel = new Label(parent, 0);
        infoLabel.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        infoLabel.setText("Select rule on the left to check on configure details.");
    }

    private void createRuleDetailConfiguration(Composite parent, Integer id) {
        Label labelsLabel = new Label(parent, 0);
        labelsLabel.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        labelsLabel.setText("Select the relationship combination to detect by this rule:");
        UIUtil.addExplanation(this.detailComp, "The analyzer specific relationships are considered.");
        this.createAnalyzerSelection(id);
    }

    private void createAnalyzerSelection(final Integer id) {
        HashSet<String> alreadyExistingLabels = new HashSet<String>();
        for (final VPMAnalyzer analyzer : this.analyzers) {
            if (!alreadyExistingLabels.add(analyzer.getRelationshipLabel())) continue;
            Button checkBtn = new Button(this.detailComp, 32);
            checkBtn.setText(analyzer.getRelationshipLabel());
            if (this.labelsToGroupID.get(id).contains(analyzer.getRelationshipLabel())) {
                checkBtn.setSelection(true);
            }
            checkBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    if (((Button)e.widget).getSelection()) {
                        ((Set)ResultHandlingConfigurationPage.this.labelsToGroupID.get(id)).add(analyzer.getRelationshipLabel());
                    } else {
                        ((Set)ResultHandlingConfigurationPage.this.labelsToGroupID.get(id)).remove(analyzer.getRelationshipLabel());
                    }
                    ResultHandlingConfigurationPage.this.listViewerAnalysis.refresh();
                }
            });
        }
    }

    public VPMAnalysisWorkflowConfiguration.ResultPresentation getResultPresentation() {
        return this.resultPresentation;
    }

    public List<DetectionRule> getDetectionRules() {
        LinkedList<DetectionRule> result = new LinkedList<DetectionRule>();
        for (Integer id : this.labelsToGroupID.keySet()) {
            BasicDetectionRule basicDetectionRule = new BasicDetectionRule(new LinkedList(this.labelsToGroupID.get(id)), this.refinementTypeToGroupID.get(id));
            result.add((DetectionRule)basicDetectionRule);
        }
        return result;
    }

    public boolean isUseMergeDetection() {
        return this.useMergeDetection;
    }

    public boolean isFullRefinementReasons() {
        return this.fullRefinementReasons;
    }

    private void enableRulesDetection(boolean enabled) {
        this.recursiveSetEnabled((Control)this.ruleConfigurationGroup, enabled);
    }

    private void recursiveSetEnabled(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetEnabled(c, enabled);
                ++n2;
            }
        } else if (ctrl != this.removeRuleButton || !enabled) {
            ctrl.setEnabled(enabled);
        }
    }

    private int findNextFreeID() {
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            if (!this.refinementTypeToGroupID.keySet().contains(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Integer getSelectedID() {
        Object selection;
        Integer id = null;
        if (this.listViewerAnalysis.getSelection() instanceof StructuredSelection && (selection = ((StructuredSelection)this.listViewerAnalysis.getSelection()).getFirstElement()) != null) {
            id = (Integer)selection;
        }
        return id;
    }

    private void rebuildDetailComp() {
        this.removeRuleDetailComponents();
        this.detailComp.pack();
        Integer selectedID = this.getSelectedID();
        if (selectedID == null) {
            this.removeRuleButton.setEnabled(false);
            this.showHowToConfigureRulesInfo(this.detailComp);
        } else {
            this.removeRuleButton.setEnabled(true);
            this.createRuleDetailConfiguration(this.detailComp, selectedID);
        }
        this.detailComp.pack();
    }

    public void setSelectedAnalyzers(List<VPMAnalyzer> analyzers) {
        if (analyzers == null) {
            throw new IllegalArgumentException();
        }
        this.analyzers = analyzers;
        this.fillInitialRuleMaps();
        this.removeInvalidEdgeLabelsFromRules();
        this.rebuildDetailComp();
        this.enableRulesDetection(this.resultPresentation == VPMAnalysisWorkflowConfiguration.ResultPresentation.REFINEMENT_BROWSER);
        this.listViewerAnalysis.refresh();
        this.update();
    }

    private void update() {
        this.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return this.resultPresentation == VPMAnalysisWorkflowConfiguration.ResultPresentation.RELATIONSHIP_GRAPH_ONLY || this.resultPresentation == VPMAnalysisWorkflowConfiguration.ResultPresentation.REFINEMENT_BROWSER && !this.labelsToGroupID.isEmpty();
    }
}

