/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.workflow;

import com.google.common.collect.Iterables;
import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import de.uka.ipd.sdq.workflow.workbench.AbstractWorkbenchDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.jobs.OpenVPMJob;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.jobs.SaveVPMJob;
import org.splevo.ui.jobs.SetRefinementsJob;
import org.splevo.ui.jobs.SetVPMJob;
import org.splevo.ui.jobs.VPMApplyRefinementsJob;
import org.splevo.ui.workflow.VPMRefinementWorkflowConfiguration;

public class VPMRefinementWorkflowDelegate
extends AbstractWorkbenchDelegate<VPMRefinementWorkflowConfiguration, UIBasedWorkflow<Blackboard<?>>> {
    private VPMRefinementWorkflowConfiguration config = null;

    public VPMRefinementWorkflowDelegate(VPMRefinementWorkflowConfiguration config) {
        this.config = config;
    }

    protected IJob createWorkflowJob(VPMRefinementWorkflowConfiguration config) {
        SPLevoProject splevoProject = config.getSplevoProjectEditor().getSplevoProject();
        SequentialBlackboardInteractingJob jobSequence = new SequentialBlackboardInteractingJob();
        jobSequence.setBlackboard((Blackboard)new SPLevoBlackBoard());
        SetVPMJob setVpmJob = new SetVPMJob(config.getVariationPointModel());
        jobSequence.add((IJob)setVpmJob);
        SetRefinementsJob setRefinementsJob = new SetRefinementsJob(config.getRefinements());
        jobSequence.add((IJob)setRefinementsJob);
        VPMApplyRefinementsJob vpmApplyRefinementsJob = new VPMApplyRefinementsJob();
        jobSequence.add((IJob)vpmApplyRefinementsJob);
        String modelNamePrefix = "" + splevoProject.getVpmModelReferences().size();
        String targetPath = String.valueOf(splevoProject.getWorkspace()) + "models/vpms/" + modelNamePrefix + "-vpm.vpm";
        boolean refactoringStarted = ((VPMModelReference)Iterables.getLast((Iterable)splevoProject.getVpmModelReferences())).isRefactoringStarted();
        SaveVPMJob saveVPMJob = new SaveVPMJob(splevoProject, targetPath, refactoringStarted);
        jobSequence.add((IJob)saveVPMJob);
        jobSequence.add((IJob)new OpenVPMJob(splevoProject, null));
        return jobSequence;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean useSeparateConsoleForEachJobRun() {
        return false;
    }

    protected VPMRefinementWorkflowConfiguration getConfiguration() {
        return this.config;
    }
}

