/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.codelocation;

import org.junit.Assert;
import org.junit.Test;
import org.splevo.tests.SPLevoTestUtil;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.codelocation.AbstractTest;
import org.splevo.vpm.analyzer.codelocation.CodeLocationVPMAnalyzer;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class CodeLocationVPMAnalyzerTest
extends AbstractTest {
    @Test
    public void testAnalyze() throws Exception {
        VPMGraph graph = SPLevoTestUtil.loadGCDVPMGraph();
        int originalNodeCount = graph.getNodeCount();
        int originalEdgeCount = graph.getEdgeCount();
        CodeLocationVPMAnalyzer analyzer = new CodeLocationVPMAnalyzer();
        VPMAnalyzerResult result = analyzer.analyze(graph);
        Assert.assertNotNull((String)"The analyzer result must not be null", (Object)result);
        Assert.assertEquals((String)"The graph's node count should not have been changed.", (long)originalNodeCount, (long)graph.getNodeCount());
        Assert.assertEquals((String)"The graph's edge count should not have been changed.", (long)originalEdgeCount, (long)graph.getEdgeCount());
        Assert.assertEquals((String)"Wrong edge descriptor count", (long)11L, (long)result.getEdgeDescriptors().size());
    }

    @Test
    public void testGetName() {
        CodeLocationVPMAnalyzer anlayzer = new CodeLocationVPMAnalyzer();
        Assert.assertNotNull((String)"The analyzer name must not be not.", (Object)anlayzer.getName());
    }

    @Test
    public void testGetRelationshipLabel() {
        CodeLocationVPMAnalyzer anlayzer = new CodeLocationVPMAnalyzer();
        Assert.assertNotNull((String)"The analyzer relationship label must not be not.", (Object)anlayzer.getRelationshipLabel());
    }
}

