/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.semantic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.graphstream.graph.Node;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.config.ChoiceConfiguration;
import org.splevo.vpm.analyzer.config.StringConfiguration;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.analyzer.semantic.AbstractTest;
import org.splevo.vpm.analyzer.semantic.SemanticVPMAnalyzer;
import org.splevo.vpm.analyzer.semantic.extensionpoint.SemanticContent;
import org.splevo.vpm.analyzer.semantic.extensionpoint.SemanticContentProvider;
import org.splevo.vpm.analyzer.semantic.extensionpoint.SemanticContentProviderRegistry;
import org.splevo.vpm.analyzer.semantic.extensionpoint.UnsupportedSoftwareElementException;
import org.splevo.vpm.analyzer.semantic.lucene.Stemming;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.variabilityFactory;

public class SharedTermSemanticAnalysisTest
extends AbstractTest {
    @Test
    public void testGetterSetter() throws UnsupportedSoftwareElementException {
        ArrayList terms = Lists.newArrayList();
        terms.add(Lists.newArrayList((Object[])new String[]{"getUseCase"}));
        terms.add(Lists.newArrayList((Object[])new String[]{"setUseCase"}));
        this.registerContentProvider(terms);
        VPMGraph vpmGraph = this.mockVPMGraph(Lists.newArrayList((Object[])new String[]{"NODE1", "NODE2"}));
        SemanticVPMAnalyzer analyzer = this.createAnalyzer("get set", Stemming.KSTEM);
        VPMAnalyzerResult result = analyzer.analyze(vpmGraph);
        Assert.assertThat((String)"Wrong number of relationship edges", (Object)result.getEdgeDescriptors().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testAllFiltered() throws UnsupportedSoftwareElementException {
        ArrayList terms = Lists.newArrayList();
        terms.add(Lists.newArrayList((Object[])new String[]{"getUseCase"}));
        terms.add(Lists.newArrayList((Object[])new String[]{"setUseCase"}));
        this.registerContentProvider(terms);
        VPMGraph vpmGraph = this.mockVPMGraph(Lists.newArrayList((Object[])new String[]{"NODE1", "NODE2"}));
        SemanticVPMAnalyzer analyzer = this.createAnalyzer("get set use case", Stemming.SNOWBALL_PORTER);
        VPMAnalyzerResult result = analyzer.analyze(vpmGraph);
        Assert.assertThat((String)"Wrong number of relationship edges", (Object)result.getEdgeDescriptors().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testNotAllVPsMatching() throws UnsupportedSoftwareElementException {
        ArrayList terms = Lists.newArrayList();
        terms.add(Lists.newArrayList((Object[])new String[]{"getMatch"}));
        terms.add(Lists.newArrayList((Object[])new String[]{"setMatch"}));
        terms.add(Lists.newArrayList((Object[])new String[]{"doesNotMaatch"}));
        this.registerContentProvider(terms);
        VPMGraph vpmGraph = this.mockVPMGraph(Lists.newArrayList((Object[])new String[]{"NODE1", "NODE2", "NODE3"}));
        SemanticVPMAnalyzer analyzer = this.createAnalyzer("get set", Stemming.SNOWBALL_PORTER);
        VPMAnalyzerResult result = analyzer.analyze(vpmGraph);
        Assert.assertThat((String)"Wrong number of relationship edges", (Object)result.getEdgeDescriptors().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testNotAllTermsMatching() throws UnsupportedSoftwareElementException {
        ArrayList terms = Lists.newArrayList();
        terms.add(Lists.newArrayList((Object[])new String[]{"getMatchsMultipleTerms"}));
        terms.add(Lists.newArrayList((Object[])new String[]{"setTermsMatched"}));
        this.registerContentProvider(terms);
        VPMGraph vpmGraph = this.mockVPMGraph(Lists.newArrayList((Object[])new String[]{"NODE1", "NODE2"}));
        SemanticVPMAnalyzer analyzer = this.createAnalyzer("get set", Stemming.SNOWBALL_PORTER);
        VPMAnalyzerResult result = analyzer.analyze(vpmGraph);
        Assert.assertThat((String)"Wrong number of relationship edges", (Object)result.getEdgeDescriptors().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong sublabel", (Object)((VPMEdgeDescriptor)result.getEdgeDescriptors().get(0)).getRelationshipSubLabel(), (Matcher)CoreMatchers.is((Object)"match term"));
    }

    private VPMGraph mockVPMGraph(List<String> nodeIds) {
        ArrayList nodeList = Lists.newArrayList();
        VPMGraph vpmGraph = (VPMGraph)Mockito.mock(VPMGraph.class);
        for (String nodeId : nodeIds) {
            Node node = this.mockGraphNodeWithVP(nodeId, vpmGraph, Lists.newArrayList((Object[])new String[]{"NewVariant"}));
            nodeList.add(node);
        }
        Mockito.when((Object)vpmGraph.getNodeCount()).thenReturn((Object)nodeList.size());
        Mockito.when((Object)vpmGraph.getNodeSet()).thenReturn((Object)nodeList);
        return vpmGraph;
    }

    private SemanticVPMAnalyzer createAnalyzer(String stopWords, Stemming stemming) {
        SemanticVPMAnalyzer analyzer = new SemanticVPMAnalyzer();
        this.setStopWordConfig(analyzer, stopWords);
        this.setStemmingConfig(analyzer, stemming.name());
        return analyzer;
    }

    private void setStemmingConfig(SemanticVPMAnalyzer analyzer, String stemming) {
        VPMAnalyzerConfigurationSet configs = analyzer.getConfigurations();
        ChoiceConfiguration stemmingConfig = (ChoiceConfiguration)configs.getConfiguration("General Configuations", "org.splevo.vpm.analyzer.semanticSTEMMING");
        stemmingConfig.setCurrentValue(stemming);
    }

    private void registerContentProvider(List<List<String>> termLists) throws UnsupportedSoftwareElementException {
        SemanticContentProvider provider = this.mockContentProviderForTermLists(termLists);
        SemanticContentProviderRegistry.getInstance().getElements().clear();
        SemanticContentProviderRegistry.getInstance().registerElement((Object)provider);
    }

    private Node mockGraphNodeWithVP(String nodeId, VPMGraph vpmGraph, List<String> variantIds) {
        VariationPoint vp = variabilityFactory.eINSTANCE.createVariationPoint();
        vp.setLocation((SoftwareElement)Mockito.mock(SoftwareElement.class));
        for (String id : variantIds) {
            Variant v = variabilityFactory.eINSTANCE.createVariant();
            v.setId(id);
            v.getImplementingElements().add((Object)((SoftwareElement)Mockito.mock(SoftwareElement.class)));
            if (vp.getVariants().size() == 0) {
                v.setLeading(Boolean.valueOf(true));
            }
            vp.getVariants().add((Object)v);
        }
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)nodeId);
        Mockito.when((Object)((VariationPoint)node.getAttribute("vp.vp", VariationPoint.class))).thenReturn((Object)vp);
        Mockito.when((Object)vpmGraph.getNode(nodeId)).thenReturn((Object)node);
        return node;
    }

    private SemanticContentProvider mockContentProviderForTermLists(List<List<String>> termLists) throws UnsupportedSoftwareElementException {
        SemanticContentProvider provider = (SemanticContentProvider)Mockito.mock(SemanticContentProvider.class);
        OngoingStubbing mockStub = Mockito.when((Object)provider.getRelevantContent((SoftwareElement)Matchers.any(SoftwareElement.class), Matchers.anyBoolean()));
        for (List<String> terms : termLists) {
            SemanticContent semantic = new SemanticContent();
            for (String term : terms) {
                semantic.addCode(term);
            }
            mockStub = mockStub.thenReturn((Object)semantic);
        }
        return provider;
    }

    private void setStopWordConfig(SemanticVPMAnalyzer analyzer, String stopWords) {
        VPMAnalyzerConfigurationSet configs = analyzer.getConfigurations();
        StringConfiguration stopWordConfig = (StringConfiguration)configs.getConfiguration("General Configuations", "org.splevo.vpm.analyzer.semanticSTOP_WORDS");
        stopWordConfig.setCurrentValue((Object)stopWords);
    }
}

