/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.semantic;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.splevo.vpm.analyzer.semantic.AbstractTest;
import org.splevo.vpm.analyzer.semantic.lucene.CodeTokenizer;

public class CodeTokenizerTest
extends AbstractTest {
    @Test
    public void testDontSplitCamelCase() throws Exception {
        StringReader inputReader = new StringReader("UseCase doSth");
        CodeTokenizer tokenizer = new CodeTokenizer((Reader)inputReader, false);
        tokenizer.reset();
        Set<String> tokens = this.readTokens(tokenizer);
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"usecase"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"dosth"));
        tokenizer.close();
    }

    @Test
    public void testSplitCamelCase() throws Exception {
        StringReader inputReader = new StringReader("UseCase doSth");
        CodeTokenizer tokenizer = new CodeTokenizer((Reader)inputReader, true);
        tokenizer.reset();
        Set<String> tokens = this.readTokens(tokenizer);
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"use"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"case"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"do"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"sth"));
        tokenizer.close();
    }

    @Test
    public void testSplitCamelCaseWithFeatureTerms() throws Exception {
        StringReader inputReader = new StringReader("UseCase featureTermVariable");
        CodeTokenizer tokenizer = new CodeTokenizer((Reader)inputReader, true, (Set)Sets.newHashSet((Object[])new String[]{"featureTerm"}), false);
        tokenizer.reset();
        Set<String> tokens = this.readTokens(tokenizer);
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"use"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"case"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"featureterm"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"variable"));
        tokenizer.close();
    }

    @Test
    public void testSplitCamelCaseWithFeatureTermUseCase() throws Exception {
        StringReader inputReader = new StringReader("UseCase featureTermVariable");
        CodeTokenizer tokenizer = new CodeTokenizer((Reader)inputReader, true, (Set)Sets.newHashSet((Object[])new String[]{"UseCase"}), false);
        tokenizer.reset();
        Set<String> tokens = this.readTokens(tokenizer);
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"usecase"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"feature"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"term"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"variable"));
        tokenizer.close();
    }

    @Test
    public void testSpecialCharacters() throws Exception {
        StringReader inputReader = new StringReader("UseCase feature.termVariable_");
        CodeTokenizer tokenizer = new CodeTokenizer((Reader)inputReader, true, (Set)Sets.newHashSet((Object[])new String[]{"UseCase"}), false);
        tokenizer.reset();
        Set<String> tokens = this.readTokens(tokenizer);
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"usecase"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"feature"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"term"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"variable"));
        tokenizer.close();
    }

    @Test
    public void testFeaturedTermIncludedInLargerTerm() throws Exception {
        StringReader inputReader = new StringReader("UseCaseDiagramGraphModel");
        CodeTokenizer tokenizer = new CodeTokenizer((Reader)inputReader, true, (Set)Sets.newHashSet((Object[])new String[]{"UseCase"}), false);
        tokenizer.reset();
        Set<String> tokens = this.readTokens(tokenizer);
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"usecase"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"graph"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"model"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"diagram"));
        tokenizer.close();
    }

    @Test
    public void testFeaturedTermContainingNonAlphaChar() throws Exception {
        StringReader inputReader = new StringReader("Use_CaseDiagramGraphModel");
        CodeTokenizer tokenizer = new CodeTokenizer((Reader)inputReader, true, (Set)Sets.newHashSet((Object[])new String[]{"UseCase"}), false);
        tokenizer.reset();
        Set<String> tokens = this.readTokens(tokenizer);
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"usecase"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"graph"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"model"));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItem((Object)"diagram"));
        tokenizer.close();
    }

    @Test
    public void fixFeaturedTerms() {
        HashSet terms = Sets.newHashSet((Object[])new String[]{"usecase"});
        String fixedString = CodeTokenizer.fixFeaturedTerms((String)"myuse_casehelloworld", (Set)terms);
        MatcherAssert.assertThat((Object)fixedString, (Matcher)CoreMatchers.is((Object)"my usecase helloworld"));
    }

    private Set<String> readTokens(CodeTokenizer tokenizer) throws IOException {
        CharTermAttribute attribute = (CharTermAttribute)tokenizer.getAttribute(CharTermAttribute.class);
        HashSet<String> tokens = new HashSet<String>();
        while (tokenizer.incrementToken()) {
            tokens.add(attribute.toString());
        }
        return tokens;
    }
}

