/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.semantic;

import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.splevo.vpm.analyzer.semantic.AbstractTest;
import org.splevo.vpm.analyzer.semantic.SemanticVPMAnalyzer;
import org.splevo.vpm.analyzer.semantic.lucene.Indexer;

public class SemanticVPMAnalyzerTest
extends AbstractTest {
    @Test
    public void testIfAnalyzeThrowsIllegalArgumentException() {
        SemanticVPMAnalyzer analyzer = new SemanticVPMAnalyzer();
        try {
            analyzer.analyze(null);
            Assert.assertTrue((String)"Analyze should throw IllegalArgumentException for null argument.", (boolean)false);
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testGetConfigurations() {
        SemanticVPMAnalyzer analyzer = new SemanticVPMAnalyzer();
        Assert.assertNotNull((String)"Null configuration map is not allowed", (Object)analyzer.getConfigurations());
    }

    @Test
    public void testGetName() {
        SemanticVPMAnalyzer analyzer = new SemanticVPMAnalyzer();
        Assert.assertNotNull((String)"Null name is not allowed", (Object)analyzer.getName());
        Assert.assertTrue((String)"Empty name not allowed", (analyzer.getName().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetRelationshipLabel() {
        SemanticVPMAnalyzer analyzer = new SemanticVPMAnalyzer();
        Assert.assertNotNull((String)"Null label is not allowed", (Object)analyzer.getRelationshipLabel());
        Assert.assertTrue((String)"Empty label not allowed", (analyzer.getRelationshipLabel().length() > 0 ? 1 : 0) != 0);
    }

    @Before
    public void cleanEnvBefore() {
        try {
            Indexer.getInstance().clearIndex();
        }
        catch (IOException e) {
            return;
        }
    }

    @After
    public void cleanEnvAfter() {
        try {
            Indexer.getInstance().clearIndex();
        }
        catch (IOException e) {
            return;
        }
    }
}

