/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.semantic;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.graphstream.graph.Node;
import org.splevo.vpm.analyzer.AbstractVPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.config.AbstractVPMAnalyzerConfiguration;
import org.splevo.vpm.analyzer.config.BooleanConfiguration;
import org.splevo.vpm.analyzer.config.ChoiceConfiguration;
import org.splevo.vpm.analyzer.config.NumericConfiguration;
import org.splevo.vpm.analyzer.config.Range;
import org.splevo.vpm.analyzer.config.StringConfiguration;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.analyzer.semantic.Config;
import org.splevo.vpm.analyzer.semantic.extensionpoint.SemanticContent;
import org.splevo.vpm.analyzer.semantic.extensionpoint.SemanticContentProvider;
import org.splevo.vpm.analyzer.semantic.extensionpoint.SemanticContentProviderRegistry;
import org.splevo.vpm.analyzer.semantic.extensionpoint.UnsupportedSoftwareElementException;
import org.splevo.vpm.analyzer.semantic.lucene.Indexer;
import org.splevo.vpm.analyzer.semantic.lucene.Stemming;
import org.splevo.vpm.analyzer.semantic.lucene.finder.SharedTermFinder;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public class SemanticVPMAnalyzer
extends AbstractVPMAnalyzer {
    private static final String RELATIONSHIP_LABEL_SEMANTIC = "Semantic";
    private static final String DISPLAYED_NAME = "Semantic VPM Analyzer";
    private Logger logger = Logger.getLogger(SemanticVPMAnalyzer.class);
    private Indexer indexer = Indexer.getInstance();
    private BooleanConfiguration includeCommentsConfig = new BooleanConfiguration("org.splevo.vpm.analyzer.semanticINCLUDE_COMMENTS", "Include comments", null, Boolean.valueOf(false));
    private BooleanConfiguration splitCamelCaseConfig = new BooleanConfiguration("org.splevo.vpm.analyzer.semanticSPLIT_CAMEL_CASE", "Split camel-case words", null, Boolean.valueOf(true));
    private ChoiceConfiguration stemmingConfig = new ChoiceConfiguration("org.splevo.vpm.analyzer.semanticSTEMMING", "Use Stemming", null, Config.DEFAULT_STEMMING, Config.AVAILABLEVALUES_STEMMING);
    private StringConfiguration stopWordsConfig = new StringConfiguration("org.splevo.vpm.analyzer.semanticSTOP_WORDS", "Stop-Words", "Terms to filter and not detect any relationships for. Stop words are filtered before stemming is applied.Put in words separated by whitespace.", "accept action add check clear close create do dump end equals find generate get handle has hash init initialize insert is load make new next parse print process read remove reset run set size start to update validate visit write", false);
    private NumericConfiguration minSharedTermConfig = new NumericConfiguration("org.splevo.vpm.analyzer.semanticMIN_SIMILARITY", "Minimum of shared terms", "The minimum number of terms two variation points have to share to get connected.", 1, 1, new Range((Number)1, (Number)Integer.MAX_VALUE));
    private StringConfiguration logIndexedTermsConfig = new StringConfiguration("org.splevo.vpm.analyzer.semanticLOG_INDEXED_TERMS", "Indexed terms log path", "If a path is defined, all indexed terms are dump to a log file in this path's directory.", "", true);
    private StringConfiguration featureTermConfig = new StringConfiguration("org.splevo.vpm.analyzer.semanticFEATURE_TERMS", "Featured Terms", "Feature Terms will not be split or normalized during analysis. Such terms should reflect semantics (e.g. feature names) that can be related to specific features. Put in words separated by whitespace.", "", false);
    private BooleanConfiguration featuredTermsOnlyConfig = new BooleanConfiguration("org.splevo.vpm.analyzer.semanticFEATURE_TERMS_ONLY", "Featured terms only", "If featured terms are defined, only those will be considered during the analysis.", Boolean.valueOf(true));
    private BooleanConfiguration similarTermSetOnlyConfig = new BooleanConfiguration("org.splevo.vpm.analyzer.semanticSIMILAR_TERM_SET_ONLY", "Similar term sets only", "Include VPs only if they share the same terms with their related neighbours.", Boolean.valueOf(true));
    private BooleanConfiguration oneSharedTermOnlyConfig = new BooleanConfiguration("org.splevo.vpm.analyzer.semanticONE_SHARED_TERM_ONLY", "One shared term only", "Include VPs only if they share a single term only with their neighbors. Is used in combination with the Similar term sets only option only.", Boolean.valueOf(false));

    public VPMAnalyzerResult analyze(VPMGraph vpmGraph) {
        if (vpmGraph == null) {
            throw new IllegalArgumentException();
        }
        if (vpmGraph.getNodeCount() == 0) {
            this.logger.info((Object)"Got empty VPM Graph. No analysis executed.");
            return null;
        }
        try {
            this.fillIndex(vpmGraph);
        }
        catch (Exception e) {
            this.logger.error((Object)"Cannot write Index. Close all open IndexWriters first.", (Throwable)e);
            return null;
        }
        if (!Strings.isNullOrEmpty((String)((String)this.logIndexedTermsConfig.getCurrentValue()))) {
            this.logIndexedTerms();
        }
        VPMAnalyzerResult result = null;
        try {
            try {
                result = this.findRelationships(vpmGraph);
            }
            catch (IOException e) {
                this.logger.error((Object)"Cannot read Index. Close all open IndexWriters first.", (Throwable)e);
                this.cleanUp();
            }
        }
        finally {
            this.cleanUp();
        }
        return result;
    }

    private void logIndexedTerms() {
        Map<String, Integer> indexedTerms = this.getTermsFromIndex();
        LinkedList lines = Lists.newLinkedList();
        lines.add("Term,VPCount");
        for (String term : indexedTerms.keySet()) {
            lines.add(String.valueOf(term) + "," + indexedTerms.get(term));
        }
        String logDirectory = this.getCurrentLogSubDirectory();
        File logFile = new File(String.valueOf(logDirectory) + "indexed-terms.csv");
        try {
            FileUtils.writeLines((File)logFile, (Collection)lines);
        }
        catch (IOException e) {
            this.logger.error((Object)"Failed to write term log", (Throwable)e);
        }
    }

    private String getCurrentLogSubDirectory() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        Calendar cal = Calendar.getInstance();
        String timeStamp = dateFormat.format(cal.getTime());
        String logDirectory = String.valueOf((String)this.logIndexedTermsConfig.getCurrentValue()) + File.separator + timeStamp + File.separator;
        return logDirectory;
    }

    private void cleanUp() {
        try {
            Indexer.getInstance().clearIndex();
        }
        catch (IOException e) {
            this.logger.error((Object)"Failure while trying to empty main index.", (Throwable)e);
        }
    }

    private Map<String, Integer> getTermsFromIndex() {
        LinkedHashMap indexedTerms = Maps.newLinkedHashMap();
        try {
            DirectoryReader indexReader = this.indexer.getIndexReader();
            Terms terms = SlowCompositeReaderWrapper.wrap((IndexReader)indexReader).terms("CONTENT");
            if (terms == null) {
                return indexedTerms;
            }
            TermsEnum termEnum = terms.iterator(null);
            BytesRef byteRef = null;
            while ((byteRef = termEnum.next()) != null) {
                String term = byteRef.utf8ToString();
                int count = indexReader.docFreq(new Term("CONTENT", byteRef));
                indexedTerms.put(term, count);
            }
            indexReader.close();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to dump index", (Throwable)e);
        }
        return indexedTerms;
    }

    public VPMAnalyzerConfigurationSet getConfigurations() {
        VPMAnalyzerConfigurationSet configurations = new VPMAnalyzerConfigurationSet();
        configurations.addConfigurations("General Configuations", new AbstractVPMAnalyzerConfiguration[]{this.stopWordsConfig, this.stemmingConfig, this.similarTermSetOnlyConfig, this.oneSharedTermOnlyConfig});
        configurations.addConfigurations("Featured Terms Configuations", new AbstractVPMAnalyzerConfiguration[]{this.featuredTermsOnlyConfig, this.featureTermConfig});
        configurations.addConfigurations("Shared Term Detection", new AbstractVPMAnalyzerConfiguration[]{this.includeCommentsConfig, this.splitCamelCaseConfig, this.minSharedTermConfig, this.logIndexedTermsConfig});
        return configurations;
    }

    public String getName() {
        return DISPLAYED_NAME;
    }

    public String getRelationshipLabel() {
        return RELATIONSHIP_LABEL_SEMANTIC;
    }

    private void fillIndex(VPMGraph vpmGraph) {
        if (vpmGraph == null) {
            throw new IllegalArgumentException();
        }
        boolean indexComments = (Boolean)this.includeCommentsConfig.getCurrentValue();
        boolean splitCamelCase = (Boolean)this.splitCamelCaseConfig.getCurrentValue();
        String stopWords = (String)this.stopWordsConfig.getCurrentValue();
        String featureTerms = (String)this.featureTermConfig.getCurrentValue();
        boolean featuredTermsOnly = (Boolean)this.featuredTermsOnlyConfig.getCurrentValue();
        String stemmingString = (String)this.stemmingConfig.getCurrentValue();
        Stemming stemming = Stemming.valueOf(stemmingString);
        this.indexer.setSplitCamelCase(splitCamelCase);
        this.indexer.setStemming(stemming);
        if (stopWords != null) {
            this.indexer.setStopWords(stopWords.split(" "));
        }
        if (featureTerms != null) {
            if (featureTerms.length() > 0) {
                this.indexer.setFeatureTermSet(new HashSet<String>(Arrays.asList(featureTerms.split(" "))));
            } else {
                this.indexer.setFeatureTermSet(new HashSet<String>());
            }
        }
        this.indexer.setFeaturedTermsOnly(featuredTermsOnly);
        for (Node node : vpmGraph.getNodeSet()) {
            VariationPoint vp = (VariationPoint)node.getAttribute("vp.vp", VariationPoint.class);
            this.indexNode(node.getId(), vp, indexComments);
        }
    }

    private void indexNode(String id, VariationPoint vp, boolean matchComments) {
        if (id == null || vp == null) {
            throw new IllegalArgumentException();
        }
        LinkedList codeTerms = Lists.newLinkedList();
        LinkedList comments = Lists.newLinkedList();
        for (Variant variant : vp.getVariants()) {
            for (SoftwareElement softwareElement : variant.getImplementingElements()) {
                this.loadTermsForSoftwareElement(matchComments, softwareElement, codeTerms, comments);
            }
        }
        String codeString = this.convertListToString(codeTerms);
        String commentString = this.convertListToString(comments);
        try {
            this.indexer.addToIndex(id, codeString, commentString);
        }
        catch (IOException e) {
            this.logger.error((Object)"Failure while adding node to index.", (Throwable)e);
        }
    }

    private void loadTermsForSoftwareElement(boolean matchComments, SoftwareElement softwareElement, List<String> codeTerms, List<String> commentTerms) {
        List semanticContentProviders = SemanticContentProviderRegistry.getInstance().getElements();
        for (SemanticContentProvider semanticContentProvider : semanticContentProviders) {
            SemanticContent relevantContent;
            try {
                relevantContent = semanticContentProvider.getRelevantContent(softwareElement, matchComments);
            }
            catch (UnsupportedSoftwareElementException e) {
                continue;
            }
            codeTerms.addAll(relevantContent.getCode());
            commentTerms.addAll(relevantContent.getComments());
        }
    }

    private String convertListToString(List<String> list) {
        return Joiner.on((String)" ").skipNulls().join(list);
    }

    private VPMAnalyzerResult findRelationships(VPMGraph graph) throws IOException {
        boolean includeComments = (Boolean)this.includeCommentsConfig.getCurrentValue();
        int minSharedTerms = 1;
        if (this.minSharedTermConfig.getCurrentValue() != null) {
            minSharedTerms = (Integer)this.minSharedTermConfig.getCurrentValue();
        }
        DirectoryReader reader = Indexer.getInstance().getIndexReader();
        SharedTermFinder finder = new SharedTermFinder(reader, includeComments, minSharedTerms);
        Table<String, String, Set<String>> sharedTermTable = finder.findSimilarEntries();
        reader.close();
        Set<String> vpFilter = this.buildImpreciseVPFilter(sharedTermTable);
        VPMAnalyzerResult result = new VPMAnalyzerResult((VPMAnalyzer)this);
        ArrayList edgeRegistry = Lists.newArrayList();
        for (Table.Cell cell : sharedTermTable.cellSet()) {
            String subLabel;
            Node node2;
            Node node1;
            VPMEdgeDescriptor edge;
            Set sharedTerms;
            String id1 = (String)cell.getRowKey();
            String id2 = (String)cell.getColumnKey();
            if (vpFilter.contains(id1) || vpFilter.contains(id2) || (sharedTerms = (Set)cell.getValue()).size() < minSharedTerms || (edge = this.buildEdgeDescriptor(node1 = graph.getNode(id1), node2 = graph.getNode(id2), subLabel = this.convertListToString(Lists.newArrayList((Iterable)sharedTerms)), edgeRegistry)) == null) continue;
            this.logAnalysisInfo(id1, id2, "", "", String.format("Shared terms: %s", subLabel));
            result.getEdgeDescriptors().add(edge);
        }
        return result;
    }

    private Set<String> buildImpreciseVPFilter(Table<String, String, Set<String>> sharedTermTable) {
        LinkedHashSet vpFilter = Sets.newLinkedHashSet();
        if (((Boolean)this.similarTermSetOnlyConfig.getCurrentValue()).booleanValue()) {
            Set referenceTerms;
            block0: for (String referenceVP : sharedTermTable.rowKeySet()) {
                Map row = sharedTermTable.row((Object)referenceVP);
                referenceTerms = null;
                for (Set currentTerms : row.values()) {
                    if (referenceTerms == null) {
                        if (((Boolean)this.oneSharedTermOnlyConfig.getCurrentValue()).booleanValue() && currentTerms.size() > 1) {
                            vpFilter.add(referenceVP);
                            continue block0;
                        }
                        referenceTerms = currentTerms;
                        continue;
                    }
                    if (referenceTerms.containsAll(currentTerms) && currentTerms.containsAll(referenceTerms)) continue;
                    vpFilter.add(referenceVP);
                    continue block0;
                }
            }
            block2: for (String referenceVP : sharedTermTable.columnKeySet()) {
                Map column = sharedTermTable.column((Object)referenceVP);
                referenceTerms = null;
                for (Set currentTerms : column.values()) {
                    if (referenceTerms == null) {
                        if (((Boolean)this.oneSharedTermOnlyConfig.getCurrentValue()).booleanValue() && currentTerms.size() > 1) {
                            vpFilter.add(referenceVP);
                            continue block2;
                        }
                        referenceTerms = currentTerms;
                        continue;
                    }
                    if (referenceTerms.containsAll(currentTerms) && currentTerms.containsAll(referenceTerms)) continue;
                    vpFilter.add(referenceVP);
                    continue block2;
                }
            }
        }
        return vpFilter;
    }
}

