/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.semantic.lucene;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class CodeTokenizer
extends Tokenizer {
    private static Logger logger = Logger.getLogger(CodeTokenizer.class);
    private Set<String> featuredTerms = null;
    private boolean featuredTermsOnly = true;
    private boolean splitCamelCase = true;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private LinkedList<String> tokens;

    public CodeTokenizer(Reader input, boolean splitCamelCase) {
        super(input);
        this.splitCamelCase = splitCamelCase;
    }

    public CodeTokenizer(Reader input, boolean splitCamelCase, Set<String> featuredTerms, boolean featuredTermsOnly) {
        this(input, splitCamelCase);
        this.featuredTerms = featuredTerms;
        this.featuredTermsOnly = featuredTermsOnly;
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        StringBuilder sb = new StringBuilder();
        int currentValue = 0;
        while ((currentValue = this.input.read()) != -1) {
            sb.append((char)currentValue);
        }
        if (sb.length() > 0) {
            String textWithoutNumericValues = sb.toString().replaceAll("[0-9]", "");
            String textWithFixedFeaturedTerms = CodeTokenizer.fixFeaturedTerms(textWithoutNumericValues, this.featuredTerms);
            this.tokens = new LinkedList<String>(Arrays.asList(textWithFixedFeaturedTerms.split("[^\\p{Alpha}[\\s]]")));
        }
        if (this.tokens.size() == 0) {
            return false;
        }
        String token = this.tokens.getFirst();
        String featuredTerm = this.containsFeaturedTerm(token);
        if (featuredTerm != null) {
            String[] split = token.split("(?i)" + featuredTerm);
            if (split.length > 0) {
                this.tokens.addAll(Arrays.asList(split));
            }
            this.termAtt.append(featuredTerm.toLowerCase());
        } else if (!this.featuredTermsOnly || this.featuredTerms == null || this.featuredTerms.size() == 0) {
            if (!this.splitCamelCase) {
                this.termAtt.append(token.toLowerCase());
            } else {
                String[] camelCaseTokens = token.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
                int i = 0;
                while (i < camelCaseTokens.length) {
                    if (i == 0) {
                        this.termAtt.append(camelCaseTokens[i].toLowerCase());
                    } else {
                        this.tokens.add(camelCaseTokens[i].toLowerCase());
                    }
                    ++i;
                }
            }
        }
        this.tokens.remove(token);
        this.tokens.remove("");
        return true;
    }

    public static String fixFeaturedTerms(String string, Set<String> terms) {
        if (terms == null) {
            return string;
        }
        for (String term : terms) {
            String pattern = String.format("(?i)%s", Joiner.on((String)".?").join((Iterable)Lists.charactersOf((String)term)));
            if (logger.isDebugEnabled()) {
                CodeTokenizer.logFixedFeaturedString(string, term, pattern);
            }
            string = string.replaceAll(pattern, " " + term + " ");
        }
        return string.trim();
    }

    private static void logFixedFeaturedString(String string, String term, String pattern) {
        ArrayList matchList = Lists.newArrayList();
        Pattern regex = Pattern.compile(pattern);
        Matcher regexMatcher = regex.matcher(string);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        if (matchList.size() > 0) {
            logger.debug((Object)("Featured term: " + term + "," + matchList));
        }
    }

    private String containsFeaturedTerm(String token) {
        if (this.featuredTerms == null || this.featuredTerms.size() == 0) {
            return null;
        }
        for (String featuredTerm : this.featuredTerms) {
            if (!token.toLowerCase().contains(featuredTerm.toLowerCase())) continue;
            return featuredTerm;
        }
        return null;
    }
}

