/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.semantic.lucene;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.splevo.vpm.analyzer.semantic.Config;
import org.splevo.vpm.analyzer.semantic.lucene.LuceneCodeAnalyzer;
import org.splevo.vpm.analyzer.semantic.lucene.Stemming;

public final class Indexer {
    private static final Version LUCENE_VERSION = Version.LUCENE_47;
    private static Logger logger = Logger.getLogger(Indexer.class);
    public static final String INDEX_VARIATIONPOINT = "VP";
    public static final String INDEX_CONTENT = "CONTENT";
    public static final String INDEX_COMMENT = "COMMENT";
    private Directory directory;
    private static Indexer instance;
    private static final FieldType TYPE_STORED_CONTENT;
    private static final FieldType TYPE_STORED_ID;
    private boolean splitCamelCase = true;
    private String[] stopWords = "get set is".split(" ");
    private Stemming stemming = Stemming.valueOf(Config.DEFAULT_STEMMING);
    private Set<String> featureTermSet;
    private boolean featuredTermsOnly;

    static {
        TYPE_STORED_CONTENT = new FieldType();
        TYPE_STORED_ID = new FieldType();
        TYPE_STORED_CONTENT.setIndexed(true);
        TYPE_STORED_CONTENT.setTokenized(true);
        TYPE_STORED_CONTENT.setStored(true);
        TYPE_STORED_CONTENT.setStoreTermVectors(true);
        TYPE_STORED_CONTENT.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS);
        TYPE_STORED_ID.setIndexed(false);
        TYPE_STORED_ID.setTokenized(false);
        TYPE_STORED_ID.setStored(true);
        TYPE_STORED_ID.setStoreTermVectors(false);
        TYPE_STORED_ID.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
    }

    private Indexer() {
        this.directory = new RAMDirectory();
    }

    public void setStopWords(String[] stopWords) {
        this.stopWords = stopWords;
    }

    public void setSplitCamelCase(boolean splitCamelCase) {
        this.splitCamelCase = splitCamelCase;
    }

    public void setStemming(Stemming stemming) {
        this.stemming = stemming;
    }

    public static synchronized Indexer getInstance() {
        if (instance == null) {
            instance = new Indexer();
        }
        return instance;
    }

    public DirectoryReader getIndexReader() throws IOException {
        return DirectoryReader.open((Directory)this.directory);
    }

    public Set<String> getFeatureTermSet() {
        return this.featureTermSet;
    }

    public void setFeatureTermSet(Set<String> featureTermSet) {
        this.featureTermSet = featureTermSet;
    }

    public boolean isFeaturedTermsOnly() {
        return this.featuredTermsOnly;
    }

    public void setFeaturedTermsOnly(boolean featuredTermsOnly) {
        this.featuredTermsOnly = featuredTermsOnly;
    }

    public void addToIndex(String variationPointId, String code, String comments) throws IOException {
        if (variationPointId == null || variationPointId.length() == 0 || code == null && comments == null) {
            throw new IllegalArgumentException();
        }
        if (!Strings.isNullOrEmpty((String)code) || !Strings.isNullOrEmpty((String)comments)) {
            this.addDocument(variationPointId, code, comments);
        }
    }

    private void addDocument(String variationPointId, String content, String comments) throws IOException {
        if (variationPointId == null) {
            logger.warn((Object)"Tried to add undefined variation point to index");
            return;
        }
        if (Strings.isNullOrEmpty((String)content) && Strings.isNullOrEmpty((String)comments)) {
            logger.warn((Object)"Tried to add document without semantic content");
            return;
        }
        Document doc = new Document();
        doc.add((IndexableField)new Field(INDEX_VARIATIONPOINT, variationPointId, TYPE_STORED_ID));
        if (!Strings.isNullOrEmpty((String)content)) {
            doc.add((IndexableField)new Field(INDEX_CONTENT, content, TYPE_STORED_CONTENT));
        }
        if (Strings.isNullOrEmpty((String)comments)) {
            doc.add((IndexableField)new Field(INDEX_COMMENT, comments, TYPE_STORED_CONTENT));
        }
        IndexWriter indexWriter = this.createIndexWriter();
        indexWriter.addDocument((Iterable)doc);
        indexWriter.close();
    }

    public void clearIndex() throws IOException {
        IndexWriter indexWriter = this.createIndexWriter();
        indexWriter.deleteAll();
        indexWriter.close();
        this.directory.close();
        this.directory = new RAMDirectory();
    }

    private IndexWriter createIndexWriter() throws IOException {
        PerFieldAnalyzerWrapper wrapper = this.createAnalzyerWrapper();
        IndexWriterConfig config = new IndexWriterConfig(LUCENE_VERSION, (Analyzer)wrapper);
        IndexWriter indexWriter = new IndexWriter(this.directory, config);
        return indexWriter;
    }

    private PerFieldAnalyzerWrapper createAnalzyerWrapper() {
        HashMap<String, LuceneCodeAnalyzer> analyzerPerField = new HashMap<String, LuceneCodeAnalyzer>();
        analyzerPerField.put(INDEX_CONTENT, new LuceneCodeAnalyzer(this.stopWords, this.splitCamelCase, this.stemming, this.featureTermSet, this.featuredTermsOnly));
        analyzerPerField.put(INDEX_COMMENT, (LuceneCodeAnalyzer)new StandardAnalyzer(LUCENE_VERSION));
        PerFieldAnalyzerWrapper aWrapper = new PerFieldAnalyzerWrapper((Analyzer)new LuceneCodeAnalyzer(this.stopWords, this.splitCamelCase, this.stemming, this.featureTermSet, this.featuredTermsOnly), analyzerPerField);
        return aWrapper;
    }
}

