/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.semantic.lucene;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.en.EnglishMinimalStemFilter;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.splevo.vpm.analyzer.semantic.lucene.PlingStemmingFilter;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.EnglishStemmer;

public enum Stemming {
    NONE,
    SNOWBALL_PORTER,
    PORTER,
    KSTEM,
    PLING,
    SSTEMMER;


    public static String[] getAvailableNames() {
        ArrayList stemmingNames = Lists.newArrayList();
        Stemming[] stemmingArray = Stemming.values();
        int n = stemmingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Stemming stemming = stemmingArray[n2];
            stemmingNames.add(stemming.name());
            ++n2;
        }
        return stemmingNames.toArray(new String[0]);
    }

    public static TokenStream wrapStemmingFilter(TokenStream stream, Stemming stemming) {
        switch (stemming) {
            case SNOWBALL_PORTER: {
                return new SnowballFilter(stream, (SnowballProgram)new EnglishStemmer());
            }
            case PORTER: {
                return new PorterStemFilter(stream);
            }
            case KSTEM: {
                return new KStemFilter(stream);
            }
            case SSTEMMER: {
                return new EnglishMinimalStemFilter(stream);
            }
            case PLING: {
                return new PlingStemmingFilter(stream);
            }
        }
        return stream;
    }
}

