/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.refinement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.graphstream.graph.Node;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.splevo.tests.SPLevoTestUtil;
import org.splevo.vpm.analyzer.AbstractTest;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.codelocation.CodeLocationVPMAnalyzer;
import org.splevo.vpm.analyzer.graph.RelationshipEdge;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.analyzer.refinement.BasicDetectionRule;
import org.splevo.vpm.refinement.RefinementType;
import org.splevo.vpm.variability.VariationPoint;

public class BasicDetectionRuleTest
extends AbstractTest {
    private Logger logger = Logger.getLogger(BasicDetectionRuleTest.class);

    @Test
    public void testDetect() throws Exception {
        VPMGraph graph = SPLevoTestUtil.loadGCDVPMGraph();
        CodeLocationVPMAnalyzer analyzer = new CodeLocationVPMAnalyzer();
        VPMAnalyzerResult result = analyzer.analyze(graph);
        ArrayList<VPMAnalyzerResult> results = new ArrayList<VPMAnalyzerResult>();
        results.add(result);
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        service.createGraphEdges(graph, results);
        ArrayList<String> edgeLabels = new ArrayList<String>();
        edgeLabels.add("CodeLocation");
        BasicDetectionRule detectionRule = new BasicDetectionRule(edgeLabels, RefinementType.MERGE);
        List refinements = detectionRule.detect(graph, true);
        Assert.assertEquals((String)"Wrong number of refinements detected", (long)2L, (long)refinements.size());
    }

    @Ignore(value="For performance only. Should not be part of each test run")
    @Test
    public void testLongSubGraph() {
        String testEdgeLabel = "TESTLABEL";
        VPMGraph graph = new VPMGraph("TESTGRAPH");
        int nodeCount = 1500;
        Node lastNode = null;
        int i = 0;
        while (i < nodeCount) {
            lastNode = this.buildAndConnectNode(testEdgeLabel, "NODE" + i, graph, lastNode);
            ++i;
        }
        this.logger.info((Object)String.format("Graph prepared with %s nodes and %s edges", graph.getNodeCount(), graph.getEdgeCount()));
        ArrayList ruleLabels = Lists.newArrayList((Object[])new String[]{testEdgeLabel});
        BasicDetectionRule rule = new BasicDetectionRule((List)ruleLabels, RefinementType.GROUPING);
        rule.detect(graph, true);
    }

    private Node buildAndConnectNode(String edgeLabel, String newNodeId, VPMGraph graph, Node lastNode) {
        VariationPoint vpB = (VariationPoint)Mockito.mock(VariationPoint.class);
        Node node = graph.addNode(newNodeId);
        node.addAttribute("vp.vp", new Object[]{vpB});
        if (lastNode != null) {
            String edgeId = String.valueOf(lastNode.getId()) + node.getId();
            RelationshipEdge edgeAB = (RelationshipEdge)graph.addEdge(edgeId, lastNode.getId(), node.getId());
            edgeAB.addRelationshipLabel(edgeLabel);
        }
        return node;
    }
}

