/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.refinement;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.splevo.vpm.analyzer.graph.RelationshipEdge;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.analyzer.refinement.DetectionRule;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementFactory;
import org.splevo.vpm.refinement.RefinementReason;
import org.splevo.vpm.refinement.RefinementType;
import org.splevo.vpm.variability.VariationPoint;

public class BasicDetectionRule
implements DetectionRule {
    private Logger logger = Logger.getLogger(BasicDetectionRule.class);
    private List<String> edgeLabels = null;
    private RefinementType refinementType = RefinementType.GROUPING;

    public BasicDetectionRule(List<String> edgeLabels, RefinementType refinementType) {
        this.edgeLabels = edgeLabels;
        this.refinementType = refinementType;
    }

    @Override
    public List<Refinement> detect(VPMGraph vpmGraph, boolean fullRefinementReasons) {
        LinkedHashMap nodeSubgraphIndex = Maps.newLinkedHashMap();
        ArrayListMultimap subgraphNodeIndex = ArrayListMultimap.create();
        ArrayListMultimap subgraphEdgeIndex = ArrayListMultimap.create();
        int nextSubgraphId = 0;
        for (Edge edge : vpmGraph.getEachEdge()) {
            Integer subgraphId;
            RelationshipEdge relationshipEdge = (RelationshipEdge)edge;
            if (!this.match(relationshipEdge)) continue;
            Node sourceNode = relationshipEdge.getSourceNode();
            Node targetNode = relationshipEdge.getTargetNode();
            Integer sourceNodeSubgraphId = (Integer)nodeSubgraphIndex.get(sourceNode);
            Integer targetNodeSubgraphId = (Integer)nodeSubgraphIndex.get(targetNode);
            if (sourceNodeSubgraphId != null && targetNodeSubgraphId != null) {
                if (!sourceNodeSubgraphId.equals(targetNodeSubgraphId)) {
                    this.mergeSubGraphNodes(nodeSubgraphIndex, (ArrayListMultimap<Integer, Node>)subgraphNodeIndex, sourceNodeSubgraphId, targetNodeSubgraphId);
                    this.mergeSubgraphEdges((ArrayListMultimap<Integer, RelationshipEdge>)subgraphEdgeIndex, sourceNodeSubgraphId, targetNodeSubgraphId);
                    continue;
                }
                if (!fullRefinementReasons) continue;
                subgraphId = sourceNodeSubgraphId;
            } else {
                subgraphId = sourceNodeSubgraphId != null ? sourceNodeSubgraphId : (targetNodeSubgraphId != null ? targetNodeSubgraphId : new Integer(nextSubgraphId++));
            }
            nodeSubgraphIndex.put(sourceNode, subgraphId);
            nodeSubgraphIndex.put(targetNode, subgraphId);
            subgraphNodeIndex.put((Object)subgraphId, (Object)sourceNode);
            subgraphNodeIndex.put((Object)subgraphId, (Object)targetNode);
            subgraphEdgeIndex.put((Object)subgraphId, (Object)relationshipEdge);
        }
        this.logger.info((Object)("Subgraph Count: " + subgraphEdgeIndex.keySet().size()));
        ArrayList refinements = Lists.newArrayList();
        for (Integer subgraphId : subgraphEdgeIndex.keySet()) {
            List subgraphEdges = subgraphEdgeIndex.get((Object)subgraphId);
            Refinement refinement = this.buildRefinementForEdges(subgraphEdges);
            refinements.add(refinement);
        }
        return refinements;
    }

    private void mergeSubgraphEdges(ArrayListMultimap<Integer, RelationshipEdge> subgraphEdgeIndex, Integer sourceNodeSubGraphId, Integer targetNodeSubGraphId) {
        List edgesToMerge = subgraphEdgeIndex.get((Object)targetNodeSubGraphId);
        subgraphEdgeIndex.putAll((Object)sourceNodeSubGraphId, (Iterable)edgesToMerge);
        subgraphEdgeIndex.removeAll((Object)targetNodeSubGraphId);
    }

    private void mergeSubGraphNodes(Map<Node, Integer> nodeSubgraphIndex, ArrayListMultimap<Integer, Node> subgraphNodeIndex, Integer sourceNodeSubGraphId, Integer targetNodeSubGraphId) {
        List nodesToMove = subgraphNodeIndex.get((Object)targetNodeSubGraphId);
        for (Node node : nodesToMove) {
            nodeSubgraphIndex.put(node, sourceNodeSubGraphId);
        }
        subgraphNodeIndex.putAll((Object)sourceNodeSubGraphId, (Iterable)nodesToMove);
        subgraphNodeIndex.removeAll((Object)targetNodeSubGraphId);
    }

    private Refinement buildRefinementForEdges(List<RelationshipEdge> subgraphEdges) {
        Refinement refinement = RefinementFactory.eINSTANCE.createRefinement();
        refinement.setType(this.getRefinementType());
        StringBuilder refinementSource = new StringBuilder();
        refinementSource.append("Detected Relationship(s): ");
        Joiner.on((String)", ").appendTo(refinementSource, this.edgeLabels);
        LinkedHashSet refinedVPs = Sets.newLinkedHashSet();
        for (RelationshipEdge edge : subgraphEdges) {
            VariationPoint sourceVP = VPMGraph.getVP(edge.getSourceNode());
            VariationPoint targetVP = VPMGraph.getVP(edge.getTargetNode());
            refinedVPs.add(sourceVP);
            refinedVPs.add(targetVP);
            RefinementReason reason = RefinementFactory.eINSTANCE.createRefinementReason();
            reason.setSource(sourceVP);
            reason.setTarget(targetVP);
            reason.setReason(Joiner.on((String)", ").join(edge.getRelationshipInfos()));
            refinement.getReasons().add((Object)reason);
        }
        refinement.getVariationPoints().addAll((Collection)refinedVPs);
        refinement.setSource(refinementSource.toString());
        return refinement;
    }

    private boolean match(RelationshipEdge edge) {
        return edge.getRelationshipLabels().containsAll(this.edgeLabels);
    }

    @Override
    public List<String> getEdgeLabels() {
        return this.edgeLabels;
    }

    @Override
    public RefinementType getRefinementType() {
        return this.refinementType;
    }
}

