/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.builder;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.Comparison;
import org.splevo.vpm.builder.VPMBuildException;
import org.splevo.vpm.builder.VPMBuilder;
import org.splevo.vpm.builder.VPMBuilderService;
import org.splevo.vpm.variability.VariationPointModel;
import org.splevo.vpm.variability.variabilityFactory;

public class DefaultVPMBuilderService
implements VPMBuilderService {
    private Logger logger = Logger.getLogger(DefaultVPMBuilderService.class);
    private static final String MSG_DIFFER_NOT_AVAILABLE = "No builder available.";
    private static final String DIFFER_EXTENSION_POINT_ID = "org.splevo.vpm.builder";
    private static final String EXTENSION_POINT_ATTR_DIFFER_CLASS = "builder.class";

    @Override
    public VariationPointModel buildVPM(Comparison comparisonModel, String variantIDLeading, String variantIDIntegration, Map<String, Object> builderOptions) throws VPMBuildException {
        List<VPMBuilder> builders = this.getVPMBuilders();
        if (builders.size() == 0) {
            throw new VPMBuildException(String.format(MSG_DIFFER_NOT_AVAILABLE, new Object[0]));
        }
        VariationPointModel vpm = variabilityFactory.eINSTANCE.createVariationPointModel();
        for (VPMBuilder vpmBuilder : builders) {
            VariationPointModel builderVPM = vpmBuilder.buildVPM(comparisonModel, variantIDLeading, variantIDIntegration);
            if (builderVPM == null) {
                this.logger.warn((Object)("Builder returned null for Variation Point Model (Builder: " + vpmBuilder.getId() + ")"));
            }
            this.mergeIntoVPM(vpm, builderVPM);
        }
        return vpm;
    }

    private void mergeIntoVPM(VariationPointModel enrichVPM, VariationPointModel mergeVPM) {
        if (mergeVPM != null) {
            enrichVPM.getSoftwareElements().addAll((Collection)mergeVPM.getSoftwareElements());
            enrichVPM.getVariationPointGroups().addAll((Collection)mergeVPM.getVariationPointGroups());
        }
    }

    @Override
    public List<VPMBuilder> getVPMBuilders() {
        IExtension[] extensions;
        LinkedList<VPMBuilder> builders = new LinkedList<VPMBuilder>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            this.logger.warn((Object)"No extension point registry available.");
            return null;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(DIFFER_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            this.logger.warn((Object)"No extension point found for the ID org.splevo.vpm.builder");
            return null;
        }
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurations;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurations = extension.getConfigurationElements();
            int n3 = configurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object o = element.createExecutableExtension(EXTENSION_POINT_ATTR_DIFFER_CLASS);
                    if (o != null && o instanceof VPMBuilder) {
                        VPMBuilder differ = (VPMBuilder)o;
                        builders.add(differ);
                    }
                }
                catch (CoreException e) {
                    this.logger.error((Object)"Failed to load VPM builder extension", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        if (this.differIdsNotUnique(builders)) {
            this.logger.warn((Object)"Two or more VPM builder with the same id loaded.");
        }
        return builders;
    }

    private boolean differIdsNotUnique(List<VPMBuilder> builders) {
        LinkedList<String> ids = new LinkedList<String>();
        for (VPMBuilder builder : builders) {
            if (ids.contains(builder.getId())) {
                return true;
            }
            ids.add(builder.getId());
        }
        return false;
    }
}

