/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.refinement;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.splevo.tests.SPLevoTestUtil;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementFactory;
import org.splevo.vpm.refinement.RefinementType;
import org.splevo.vpm.refinement.VPMRefinementService;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class VPMRefinementServiceTest {
    private VariationPointModel initialVpm = null;

    @Before
    public void setUp() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        try {
            this.initialVpm = SPLevoTestUtil.loadGCDVPMModel();
        }
        catch (Exception e) {
            Assert.fail((String)"Failed to load initial variation point model");
        }
        Assert.assertEquals((String)"wrong number of initial variation point groups", (long)7L, (long)this.initialVpm.getVariationPointGroups().size());
    }

    @Test
    public void testGroupRefinements() throws IOException, InterruptedException {
        ArrayList<Refinement> refinements = new ArrayList<Refinement>();
        Refinement refinement = RefinementFactory.eINSTANCE.createRefinement();
        refinement.setSource("Manual");
        refinement.setType(RefinementType.GROUPING);
        for (VariationPointGroup group : this.initialVpm.getVariationPointGroups()) {
            for (VariationPoint vp : group.getVariationPoints()) {
                SoftwareElement element = vp.getLocation();
                if (!"gcd()".equals(element.getLabel())) continue;
                refinement.getVariationPoints().add((Object)vp);
            }
        }
        refinements.add(refinement);
        Assert.assertEquals((String)"wrong number of refinements identified", (long)1L, (long)refinements.size());
        VPMRefinementService refinementService = new VPMRefinementService();
        VariationPointModel refinedVPM = refinementService.applyRefinements(refinements, this.initialVpm);
        Assert.assertEquals((String)"wrong number of variation point groups after refinement", (long)3L, (long)refinedVPM.getVariationPointGroups().size());
        for (VariationPointGroup vpGroup : refinedVPM.getVariationPointGroups()) {
            if (!vpGroup.getName().equals("gcd")) continue;
            SoftwareElement softwareElement = ((VariationPoint)vpGroup.getVariationPoints().get(0)).getLocation();
            Assert.assertEquals((String)"Wrong enclosing software element", (Object)"gcd()", (Object)softwareElement.getLabel());
        }
    }

    @Test
    public void testMergeRefinements() throws IOException, InterruptedException {
        ArrayList<Refinement> refinements = new ArrayList<Refinement>();
        Refinement refinement = RefinementFactory.eINSTANCE.createRefinement();
        refinement.setSource("Manual");
        refinement.setType(RefinementType.MERGE);
        for (VariationPointGroup group : this.initialVpm.getVariationPointGroups()) {
            for (VariationPoint vp : group.getVariationPoints()) {
                SoftwareElement element = vp.getLocation();
                if (!"gcd()".equals(element.getLabel())) continue;
                refinement.getVariationPoints().add((Object)vp);
            }
        }
        refinements.add(refinement);
        Assert.assertEquals((String)"wrong number of refinements identified", (long)1L, (long)refinements.size());
        VPMRefinementService refinementService = new VPMRefinementService();
        VariationPointModel refinedVPM = refinementService.applyRefinements(refinements, this.initialVpm);
        Assert.assertEquals((String)"wrong number of variation point groups after refinement", (long)3L, (long)refinedVPM.getVariationPointGroups().size());
        for (VariationPointGroup vpGroup : refinedVPM.getVariationPointGroups()) {
            if (!vpGroup.getName().equals("gcd")) continue;
            SoftwareElement softwareElement = ((VariationPoint)vpGroup.getVariationPoints().get(0)).getLocation();
            Assert.assertEquals((String)"Wrong enclosing software element", (Object)"gcd()", (Object)softwareElement.getLabel());
        }
    }
}

