/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.refinement;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class VPMRefinementService {
    private Logger logger = Logger.getLogger(VPMRefinementService.class);

    public VariationPointModel applyRefinements(List<Refinement> refinements, VariationPointModel vpm) {
        for (Refinement refinement : refinements) {
            this.applyRefinements((List<Refinement>)refinement.getSubRefinements(), vpm);
            switch (refinement.getType()) {
                case GROUPING: {
                    this.applyGrouping(vpm, refinement);
                    break;
                }
                case MERGE: {
                    this.applyMerging(vpm, refinement);
                    break;
                }
                default: {
                    this.logger.warn((Object)("Unsupported refinement type: " + (Object)((Object)refinement.getType())));
                }
            }
        }
        return vpm;
    }

    private void applyMerging(VariationPointModel vpm, Refinement refinement) {
        VariationPoint survivingVP = (VariationPoint)refinement.getVariationPoints().get(0);
        HashMap<String, Variant> variantMap = new HashMap<String, Variant>();
        for (VariationPoint vp : refinement.getVariationPoints()) {
            for (Variant variant : vp.getVariants()) {
                if (variantMap.containsKey(variant.getId())) {
                    EList swElements = variant.getImplementingElements();
                    ((Variant)variantMap.get(variant.getId())).getImplementingElements().addAll((Collection)swElements);
                    continue;
                }
                variantMap.put(variant.getId(), variant);
            }
            if (vp.equals(survivingVP)) continue;
            VariationPointGroup oldGroup = vp.getGroup();
            oldGroup.getVariationPoints().remove((Object)vp);
        }
        if (!Strings.isNullOrEmpty((String)refinement.getId())) {
            survivingVP.setName(refinement.getId());
        }
        if (!Strings.isNullOrEmpty((String)refinement.getDescription())) {
            survivingVP.setDescription(refinement.getDescription());
        }
        LinkedList<VariationPointGroup> vpGroupsToDelete = new LinkedList<VariationPointGroup>();
        for (VariationPointGroup oldGroup : vpm.getVariationPointGroups()) {
            if (oldGroup.getVariationPoints().size() != 0) continue;
            vpGroupsToDelete.add(oldGroup);
        }
        vpm.getVariationPointGroups().removeAll(vpGroupsToDelete);
        survivingVP.getVariants().clear();
        survivingVP.getVariants().addAll(variantMap.values());
    }

    private void applyGrouping(VariationPointModel vpm, Refinement refinement) {
        EList<VariationPoint> variationPoints = refinement.getVariationPoints();
        for (Refinement subRef : refinement.getSubRefinements()) {
            if (subRef.getVariationPoints().size() <= 0) continue;
            VariationPoint subRefRepresentingVP = (VariationPoint)subRef.getVariationPoints().get(0);
            variationPoints.add((Object)subRefRepresentingVP);
        }
        if (variationPoints.size() == 0) {
            throw new RuntimeException("Tried to apply completely empty grouping.");
        }
        this.combineGroups(vpm, variationPoints, refinement.getId(), refinement.getDescription());
    }

    private void combineGroups(VariationPointModel vpm, EList<VariationPoint> variationPoints, String newGroupName, String newGroupDescription) {
        VariationPointGroup survivingGroup = ((VariationPoint)variationPoints.get(0)).getGroup();
        for (VariationPoint vp : variationPoints) {
            if (vp.getGroup().equals(survivingGroup)) continue;
            VariationPointGroup oldGroup = vp.getGroup();
            vp.setGroup(survivingGroup);
            vpm.getVariationPointGroups().remove((Object)oldGroup);
        }
        if (!Strings.isNullOrEmpty((String)newGroupName)) {
            survivingGroup.setName(newGroupName);
        }
        if (!Strings.isNullOrEmpty((String)newGroupDescription)) {
            survivingGroup.setDescription(newGroupDescription);
        }
    }
}

