/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.refinement;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementFactory;
import org.splevo.vpm.refinement.RefinementModel;
import org.splevo.vpm.refinement.RefinementPackage;
import org.splevo.vpm.refinement.RefinementReason;
import org.splevo.vpm.variability.VariationPoint;

public class RefinementUtil {
    public static final String REFINEMENT_FILE_EXTENSION = "refinement";

    public static RefinementModel load(File refinementFile) throws IOException {
        RefinementPackage.eINSTANCE.eClass();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(REFINEMENT_FILE_EXTENSION, new XMIResourceFactoryImpl());
        SPLevoResourceSet rs = new SPLevoResourceSet();
        Resource r = rs.createResource(URI.createPlatformResourceURI((String)refinementFile.getPath(), (boolean)true));
        r.load(null);
        EcoreUtil.resolveAll((ResourceSet)rs);
        EObject model = (EObject)r.getContents().get(0);
        if (!(model instanceof RefinementModel)) {
            throw new IOException("Model is not a valid refinement model: " + model.getClass().getName());
        }
        RefinementModel splEvoProjectModel = (RefinementModel)model;
        return splEvoProjectModel;
    }

    public static void save(RefinementModel refinementModel, File filePath) throws IOException {
        RefinementUtil.save(refinementModel, filePath, false);
    }

    public static void save(RefinementModel refinementModel, File filePath, boolean isAbsolutePath) throws IOException {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put(REFINEMENT_FILE_EXTENSION, new XMIResourceFactoryImpl());
        SPLevoResourceSet resSet = new SPLevoResourceSet();
        URI resourceUri = null;
        resourceUri = isAbsolutePath ? URI.createFileURI((String)filePath.getAbsolutePath()) : URI.createPlatformResourceURI((String)filePath.getPath(), (boolean)true);
        Resource resource = resSet.createResource(resourceUri);
        resource.getContents().add((Object)refinementModel);
        resource.save(Collections.EMPTY_MAP);
    }

    public static List<RefinementReason> getReasons(Refinement originalRefinement, Collection<VariationPoint> vps) {
        ArrayList reasons = Lists.newArrayList();
        for (RefinementReason reason : originalRefinement.getReasons()) {
            boolean isSourceContained = vps.contains(reason.getSource());
            boolean isTargetContained = vps.contains(reason.getTarget());
            if (isSourceContained && isTargetContained) {
                reasons.add(reason);
                continue;
            }
            if (!isSourceContained && !isTargetContained) continue;
            RefinementReason copy = RefinementFactory.eINSTANCE.createRefinementReason();
            copy.setReason(reason.getReason());
            copy.setSource(reason.getSource());
            copy.setTarget(reason.getTarget());
            reasons.add(copy);
        }
        return reasons;
    }
}

