/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm;

import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.splevo.vpm.VPMExtension;

public class Activator
extends Plugin {
    private static final String VPM_EXTENSION_EXTENSION_POINT_ID = "org.splevo.vpm.extension";
    private static final String EXTENSION_POINT_ATTR_EXTENSION_CLASS = "extension.class";
    private Logger logger = Logger.getLogger(Activator.class);
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        URL confURL = this.getBundle().getEntry("log4j.properties");
        PropertyConfigurator.configure((String)FileLocator.toFileURL((URL)confURL).getFile());
        this.logger.info((Object)("Logging using log4j and configuration " + FileLocator.toFileURL((URL)confURL).getFile()));
        super.start(bundleContext);
        this.loadVPMModelExtensions();
    }

    private void loadVPMModelExtensions() {
        IExtension[] extensions;
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            this.logger.warn((Object)"No extension point registry available.");
        }
        if ((extensionPoint = registry.getExtensionPoint(VPM_EXTENSION_EXTENSION_POINT_ID)) == null) {
            this.logger.warn((Object)"No extension point found for the ID org.splevo.vpm.extension");
        }
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurations;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurations = extension.getConfigurationElements();
            int n3 = configurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object o = element.createExecutableExtension(EXTENSION_POINT_ATTR_EXTENSION_CLASS);
                    if (o != null && o instanceof VPMExtension) {
                        VPMExtension vpmExtension = (VPMExtension)o;
                        vpmExtension.init();
                        this.logger.debug((Object)String.format("VPM Extension %s intialized", vpmExtension.getName()));
                    }
                }
                catch (CoreException e) {
                    this.logger.error((Object)"Failed to load and initialize VPM extension", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

