/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointModel;
import org.splevo.vpm.variability.variabilityPackage;

public class VPMUtil {
    public static final String VPM_FILE_EXTENSION = "vpm";

    public static VariationPointModel loadVariationPointModel(File vpmFile, ResourceSet rs) throws IOException {
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put(VPM_FILE_EXTENSION, new XMIResourceFactoryImpl());
        variabilityPackage.eINSTANCE.eClass();
        Resource r = rs.createResource(URI.createPlatformResourceURI((String)vpmFile.getPath(), (boolean)true));
        r.load(null);
        EObject model = (EObject)r.getContents().get(0);
        if (!(model instanceof VariationPointModel)) {
            throw new IOException("Model is not a valid VariationPointModel: " + model.getClass().getName());
        }
        VariationPointModel splEvoProjectModel = (VariationPointModel)model;
        return splEvoProjectModel;
    }

    public static void save(VariationPointModel vpm, File filePath) throws IOException {
        VPMUtil.save(vpm, URI.createPlatformResourceURI((String)filePath.getPath(), (boolean)true));
    }

    public static void save(VariationPointModel vpm, URI uri) throws IOException {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put(VPM_FILE_EXTENSION, new XMIResourceFactoryImpl());
        SPLevoResourceSet resSet = new SPLevoResourceSet();
        Resource resource = resSet.createResource(uri);
        resource.getContents().add((Object)vpm);
        resource.save(Collections.EMPTY_MAP);
    }

    public static Variant getVariantFromVP(VariationPoint vp, String variantID) {
        for (Variant v : vp.getVariants()) {
            if (!v.getId().equals(variantID)) continue;
            return v;
        }
        return null;
    }
}

