/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.variability.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.splevo.vpm.variability.BindingTime;
import org.splevo.vpm.variability.CustomizableDescriptionHaving;
import org.splevo.vpm.variability.CustomizableNameHaving;
import org.splevo.vpm.variability.Extensible;
import org.splevo.vpm.variability.Identifier;
import org.splevo.vpm.variability.VariabilityType;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;
import org.splevo.vpm.variability.variabilityPackage;

public class variabilityValidator
extends EObjectValidator {
    public static final variabilityValidator INSTANCE = new variabilityValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.splevo.vpm.variability";
    public static final int VARIATION_POINT__ALL_VALIDATORS_SUCCEED = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;

    protected EPackage getEPackage() {
        return variabilityPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateVariationPoint((VariationPoint)value, diagnostics, context);
            }
            case 1: {
                return this.validateVariant((Variant)value, diagnostics, context);
            }
            case 2: {
                return this.validateVariationPointModel((VariationPointModel)value, diagnostics, context);
            }
            case 3: {
                return this.validateVariationPointGroup((VariationPointGroup)value, diagnostics, context);
            }
            case 4: {
                return this.validateCustomizableDescriptionHaving((CustomizableDescriptionHaving)value, diagnostics, context);
            }
            case 5: {
                return this.validateCustomizableNameHaving((CustomizableNameHaving)value, diagnostics, context);
            }
            case 6: {
                return this.validateIdentifier((Identifier)value, diagnostics, context);
            }
            case 7: {
                return this.validateExtensible((Extensible)((Object)value), diagnostics, context);
            }
            case 8: {
                return this.validateVariabilityType((VariabilityType)((Object)value), diagnostics, context);
            }
            case 9: {
                return this.validateBindingTime((BindingTime)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateVariationPoint(VariationPoint variationPoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(variationPoint, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(variationPoint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(variationPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(variationPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(variationPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(variationPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(variationPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(variationPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(variationPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateVariationPoint_allValidatorsSucceed(variationPoint, diagnostics, context);
        }
        return result;
    }

    public boolean validateVariationPoint_allValidatorsSucceed(VariationPoint variationPoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return variationPoint.allValidatorsSucceed(diagnostics, context);
    }

    public boolean validateVariant(Variant variant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(variant, diagnostics, context);
    }

    public boolean validateVariationPointModel(VariationPointModel variationPointModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(variationPointModel, diagnostics, context);
    }

    public boolean validateVariationPointGroup(VariationPointGroup variationPointGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(variationPointGroup, diagnostics, context);
    }

    public boolean validateCustomizableDescriptionHaving(CustomizableDescriptionHaving customizableDescriptionHaving, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(customizableDescriptionHaving, diagnostics, context);
    }

    public boolean validateCustomizableNameHaving(CustomizableNameHaving customizableNameHaving, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(customizableNameHaving, diagnostics, context);
    }

    public boolean validateIdentifier(Identifier identifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(identifier, diagnostics, context);
    }

    public boolean validateExtensible(Extensible extensible, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateVariabilityType(VariabilityType variabilityType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateBindingTime(BindingTime bindingTime, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

